// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
 */
@Fluent
public final class LogSettings implements JsonSerializable<LogSettings> {
    /*
     * Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of
     * Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     */
    private String category;

    /*
     * Name of a Diagnostic Log category group for a resource type this setting is applied to. To obtain the list of
     * Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     */
    private String categoryGroup;

    /*
     * a value indicating whether this log is enabled.
     */
    private boolean enabled;

    /*
     * the retention policy for this log.
     */
    private RetentionPolicy retentionPolicy;

    /**
     * Creates an instance of LogSettings class.
     */
    public LogSettings() {
    }

    /**
     * Get the category property: Name of a Diagnostic Log category for a resource type this setting is applied to. To
     * obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     * 
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Set the category property: Name of a Diagnostic Log category for a resource type this setting is applied to. To
     * obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     * 
     * @param category the category value to set.
     * @return the LogSettings object itself.
     */
    public LogSettings withCategory(String category) {
        this.category = category;
        return this;
    }

    /**
     * Get the categoryGroup property: Name of a Diagnostic Log category group for a resource type this setting is
     * applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic
     * settings operation.
     * 
     * @return the categoryGroup value.
     */
    public String categoryGroup() {
        return this.categoryGroup;
    }

    /**
     * Set the categoryGroup property: Name of a Diagnostic Log category group for a resource type this setting is
     * applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic
     * settings operation.
     * 
     * @param categoryGroup the categoryGroup value to set.
     * @return the LogSettings object itself.
     */
    public LogSettings withCategoryGroup(String categoryGroup) {
        this.categoryGroup = categoryGroup;
        return this;
    }

    /**
     * Get the enabled property: a value indicating whether this log is enabled.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: a value indicating whether this log is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the LogSettings object itself.
     */
    public LogSettings withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the retentionPolicy property: the retention policy for this log.
     * 
     * @return the retentionPolicy value.
     */
    public RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    /**
     * Set the retentionPolicy property: the retention policy for this log.
     * 
     * @param retentionPolicy the retentionPolicy value to set.
     * @return the LogSettings object itself.
     */
    public LogSettings withRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (retentionPolicy() != null) {
            retentionPolicy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("categoryGroup", this.categoryGroup);
        jsonWriter.writeJsonField("retentionPolicy", this.retentionPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LogSettings.
     */
    public static LogSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogSettings deserializedLogSettings = new LogSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedLogSettings.enabled = reader.getBoolean();
                } else if ("category".equals(fieldName)) {
                    deserializedLogSettings.category = reader.getString();
                } else if ("categoryGroup".equals(fieldName)) {
                    deserializedLogSettings.categoryGroup = reader.getString();
                } else if ("retentionPolicy".equals(fieldName)) {
                    deserializedLogSettings.retentionPolicy = RetentionPolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogSettings;
        });
    }
}
