// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.WorkspaceInfoProperties;
import java.io.IOException;

/**
 * Information about a Log Analytics Workspace.
 */
@Fluent
public final class WorkspaceInfo implements JsonSerializable<WorkspaceInfo> {
    /*
     * Azure Resource Manager identifier of the Log Analytics Workspace.
     */
    private String id;

    /*
     * Location of the Log Analytics workspace.
     */
    private String location;

    /*
     * Resource properties.
     */
    private WorkspaceInfoProperties innerProperties = new WorkspaceInfoProperties();

    /**
     * Creates an instance of WorkspaceInfo class.
     */
    public WorkspaceInfo() {
    }

    /**
     * Get the id property: Azure Resource Manager identifier of the Log Analytics Workspace.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Azure Resource Manager identifier of the Log Analytics Workspace.
     * 
     * @param id the id value to set.
     * @return the WorkspaceInfo object itself.
     */
    public WorkspaceInfo withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the location property: Location of the Log Analytics workspace.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: Location of the Log Analytics workspace.
     * 
     * @param location the location value to set.
     * @return the WorkspaceInfo object itself.
     */
    public WorkspaceInfo withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private WorkspaceInfoProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the customerId property: Log Analytics workspace identifier.
     * 
     * @return the customerId value.
     */
    public String customerId() {
        return this.innerProperties() == null ? null : this.innerProperties().customerId();
    }

    /**
     * Set the customerId property: Log Analytics workspace identifier.
     * 
     * @param customerId the customerId value to set.
     * @return the WorkspaceInfo object itself.
     */
    public WorkspaceInfo withCustomerId(String customerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkspaceInfoProperties();
        }
        this.innerProperties().withCustomerId(customerId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model WorkspaceInfo"));
        }
        if (location() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property location in model WorkspaceInfo"));
        }
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property innerProperties in model WorkspaceInfo"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceInfo.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspaceInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspaceInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WorkspaceInfo.
     */
    public static WorkspaceInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceInfo deserializedWorkspaceInfo = new WorkspaceInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedWorkspaceInfo.id = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedWorkspaceInfo.location = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedWorkspaceInfo.innerProperties = WorkspaceInfoProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkspaceInfo;
        });
    }
}
