/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.DataCollectionRuleResourceProperties;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDataSources;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDestinations;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleMetadata;
import com.azure.resourcemanager.monitor.models.DataFlow;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleProvisioningState;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleResourceKind;
import com.azure.resourcemanager.monitor.models.StreamDeclaration;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DataCollectionRuleResourceInner
extends Resource {
    private DataCollectionRuleResourceProperties innerProperties;
    private KnownDataCollectionRuleResourceKind kind;
    private String etag;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private DataCollectionRuleResourceProperties innerProperties() {
        return this.innerProperties;
    }

    public KnownDataCollectionRuleResourceKind kind() {
        return this.kind;
    }

    public DataCollectionRuleResourceInner withKind(KnownDataCollectionRuleResourceKind kind) {
        this.kind = kind;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public DataCollectionRuleResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DataCollectionRuleResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public DataCollectionRuleResourceInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataCollectionRuleResourceProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String immutableId() {
        return this.innerProperties() == null ? null : this.innerProperties().immutableId();
    }

    public String dataCollectionEndpointId() {
        return this.innerProperties() == null ? null : this.innerProperties().dataCollectionEndpointId();
    }

    public DataCollectionRuleResourceInner withDataCollectionEndpointId(String dataCollectionEndpointId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataCollectionRuleResourceProperties();
        }
        this.innerProperties().withDataCollectionEndpointId(dataCollectionEndpointId);
        return this;
    }

    public DataCollectionRuleMetadata metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public Map<String, StreamDeclaration> streamDeclarations() {
        return this.innerProperties() == null ? null : this.innerProperties().streamDeclarations();
    }

    public DataCollectionRuleResourceInner withStreamDeclarations(Map<String, StreamDeclaration> streamDeclarations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataCollectionRuleResourceProperties();
        }
        this.innerProperties().withStreamDeclarations((Map)streamDeclarations);
        return this;
    }

    public DataCollectionRuleDataSources dataSources() {
        return this.innerProperties() == null ? null : this.innerProperties().dataSources();
    }

    public DataCollectionRuleResourceInner withDataSources(DataCollectionRuleDataSources dataSources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataCollectionRuleResourceProperties();
        }
        this.innerProperties().withDataSources(dataSources);
        return this;
    }

    public DataCollectionRuleDestinations destinations() {
        return this.innerProperties() == null ? null : this.innerProperties().destinations();
    }

    public DataCollectionRuleResourceInner withDestinations(DataCollectionRuleDestinations destinations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataCollectionRuleResourceProperties();
        }
        this.innerProperties().withDestinations(destinations);
        return this;
    }

    public List<DataFlow> dataFlows() {
        return this.innerProperties() == null ? null : this.innerProperties().dataFlows();
    }

    public DataCollectionRuleResourceInner withDataFlows(List<DataFlow> dataFlows) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataCollectionRuleResourceProperties();
        }
        this.innerProperties().withDataFlows((List)dataFlows);
        return this;
    }

    public KnownDataCollectionRuleProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataCollectionRuleResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (DataCollectionRuleResourceInner)((Object)jsonReader.readObject(reader -> {
            DataCollectionRuleResourceInner deserializedDataCollectionRuleResourceInner = new DataCollectionRuleResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDataCollectionRuleResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceInner.innerProperties = DataCollectionRuleResourceProperties.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceInner.kind = KnownDataCollectionRuleResourceKind.fromString(reader.getString());
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataCollectionRuleResourceInner;
        }));
    }
}

