// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The configuration to set whether network access from public internet to the endpoints are allowed.
 */
public final class KnownPublicNetworkAccessOptions extends ExpandableStringEnum<KnownPublicNetworkAccessOptions> {
    /**
     * Static value Enabled for KnownPublicNetworkAccessOptions.
     */
    public static final KnownPublicNetworkAccessOptions ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for KnownPublicNetworkAccessOptions.
     */
    public static final KnownPublicNetworkAccessOptions DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of KnownPublicNetworkAccessOptions value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public KnownPublicNetworkAccessOptions() {
    }

    /**
     * Creates or finds a KnownPublicNetworkAccessOptions from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding KnownPublicNetworkAccessOptions.
     */
    public static KnownPublicNetworkAccessOptions fromString(String name) {
        return fromString(name, KnownPublicNetworkAccessOptions.class);
    }

    /**
     * Gets known KnownPublicNetworkAccessOptions values.
     * 
     * @return known KnownPublicNetworkAccessOptions values.
     */
    public static Collection<KnownPublicNetworkAccessOptions> values() {
        return values(KnownPublicNetworkAccessOptions.class);
    }
}
