// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleAssociationMetadata;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleAssociationProvisioningState;
import java.io.IOException;

/**
 * Definition of generic ARM proxy resource.
 */
@Fluent
public final class DataCollectionRuleAssociationProxyOnlyResourceInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private DataCollectionRuleAssociationProxyOnlyResourceProperties innerProperties;

    /*
     * Resource entity tag (ETag).
     */
    private String etag;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of DataCollectionRuleAssociationProxyOnlyResourceInner class.
     */
    public DataCollectionRuleAssociationProxyOnlyResourceInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private DataCollectionRuleAssociationProxyOnlyResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: Resource entity tag (ETag).
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the description property: Description of the association.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the association.
     * 
     * @param description the description value to set.
     * @return the DataCollectionRuleAssociationProxyOnlyResourceInner object itself.
     */
    public DataCollectionRuleAssociationProxyOnlyResourceInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataCollectionRuleAssociationProxyOnlyResourceProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the dataCollectionRuleId property: The resource ID of the data collection rule that is to be associated.
     * 
     * @return the dataCollectionRuleId value.
     */
    public String dataCollectionRuleId() {
        return this.innerProperties() == null ? null : this.innerProperties().dataCollectionRuleId();
    }

    /**
     * Set the dataCollectionRuleId property: The resource ID of the data collection rule that is to be associated.
     * 
     * @param dataCollectionRuleId the dataCollectionRuleId value to set.
     * @return the DataCollectionRuleAssociationProxyOnlyResourceInner object itself.
     */
    public DataCollectionRuleAssociationProxyOnlyResourceInner withDataCollectionRuleId(String dataCollectionRuleId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataCollectionRuleAssociationProxyOnlyResourceProperties();
        }
        this.innerProperties().withDataCollectionRuleId(dataCollectionRuleId);
        return this;
    }

    /**
     * Get the dataCollectionEndpointId property: The resource ID of the data collection endpoint that is to be
     * associated.
     * 
     * @return the dataCollectionEndpointId value.
     */
    public String dataCollectionEndpointId() {
        return this.innerProperties() == null ? null : this.innerProperties().dataCollectionEndpointId();
    }

    /**
     * Set the dataCollectionEndpointId property: The resource ID of the data collection endpoint that is to be
     * associated.
     * 
     * @param dataCollectionEndpointId the dataCollectionEndpointId value to set.
     * @return the DataCollectionRuleAssociationProxyOnlyResourceInner object itself.
     */
    public DataCollectionRuleAssociationProxyOnlyResourceInner
        withDataCollectionEndpointId(String dataCollectionEndpointId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataCollectionRuleAssociationProxyOnlyResourceProperties();
        }
        this.innerProperties().withDataCollectionEndpointId(dataCollectionEndpointId);
        return this;
    }

    /**
     * Get the provisioningState property: The resource provisioning state.
     * 
     * @return the provisioningState value.
     */
    public KnownDataCollectionRuleAssociationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the metadata property: Metadata about the resource.
     * 
     * @return the metadata value.
     */
    public DataCollectionRuleAssociationMetadata metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataCollectionRuleAssociationProxyOnlyResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataCollectionRuleAssociationProxyOnlyResourceInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataCollectionRuleAssociationProxyOnlyResourceInner.
     */
    public static DataCollectionRuleAssociationProxyOnlyResourceInner fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            DataCollectionRuleAssociationProxyOnlyResourceInner deserializedDataCollectionRuleAssociationProxyOnlyResourceInner
                = new DataCollectionRuleAssociationProxyOnlyResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDataCollectionRuleAssociationProxyOnlyResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDataCollectionRuleAssociationProxyOnlyResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDataCollectionRuleAssociationProxyOnlyResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDataCollectionRuleAssociationProxyOnlyResourceInner.innerProperties
                        = DataCollectionRuleAssociationProxyOnlyResourceProperties.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedDataCollectionRuleAssociationProxyOnlyResourceInner.etag = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedDataCollectionRuleAssociationProxyOnlyResourceInner.systemData
                        = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataCollectionRuleAssociationProxyOnlyResourceInner;
        });
    }
}
