// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.MetricAlertStatus;
import java.io.IOException;
import java.util.List;

/**
 * Represents a collection of alert rule resources.
 */
@Fluent
public final class MetricAlertStatusCollectionInner implements JsonSerializable<MetricAlertStatusCollectionInner> {
    /*
     * the values for the alert rule resources.
     */
    private List<MetricAlertStatus> value;

    /**
     * Creates an instance of MetricAlertStatusCollectionInner class.
     */
    public MetricAlertStatusCollectionInner() {
    }

    /**
     * Get the value property: the values for the alert rule resources.
     * 
     * @return the value value.
     */
    public List<MetricAlertStatus> value() {
        return this.value;
    }

    /**
     * Set the value property: the values for the alert rule resources.
     * 
     * @param value the value value to set.
     * @return the MetricAlertStatusCollectionInner object itself.
     */
    public MetricAlertStatusCollectionInner withValue(List<MetricAlertStatus> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricAlertStatusCollectionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricAlertStatusCollectionInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricAlertStatusCollectionInner.
     */
    public static MetricAlertStatusCollectionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricAlertStatusCollectionInner deserializedMetricAlertStatusCollectionInner
                = new MetricAlertStatusCollectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<MetricAlertStatus> value = reader.readArray(reader1 -> MetricAlertStatus.fromJson(reader1));
                    deserializedMetricAlertStatusCollectionInner.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricAlertStatusCollectionInner;
        });
    }
}
