// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An Activity Log Alert rule condition that is met by comparing the field and value of an Activity Log event.
 * This condition must contain 'field' and either 'equals' or 'containsAny'.
 */
@Fluent
public class AlertRuleLeafCondition implements JsonSerializable<AlertRuleLeafCondition> {
    /*
     * The name of the Activity Log event's field that this condition will examine.
     * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level',
     * 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything
     * beginning with 'properties'.
     */
    private String field;

    /*
     * The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is
     * met.
     */
    private String equals;

    /*
     * The value of the event's field will be compared to the values in this array (case-insensitive) to determine if
     * the condition is met.
     */
    private List<String> containsAny;

    /**
     * Creates an instance of AlertRuleLeafCondition class.
     */
    public AlertRuleLeafCondition() {
    }

    /**
     * Get the field property: The name of the Activity Log event's field that this condition will examine.
     * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level',
     * 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything
     * beginning with 'properties'.
     * 
     * @return the field value.
     */
    public String field() {
        return this.field;
    }

    /**
     * Set the field property: The name of the Activity Log event's field that this condition will examine.
     * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level',
     * 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything
     * beginning with 'properties'.
     * 
     * @param field the field value to set.
     * @return the AlertRuleLeafCondition object itself.
     */
    public AlertRuleLeafCondition withField(String field) {
        this.field = field;
        return this;
    }

    /**
     * Get the equals property: The value of the event's field will be compared to this value (case-insensitive) to
     * determine if the condition is met.
     * 
     * @return the equals value.
     */
    public String equals() {
        return this.equals;
    }

    /**
     * Set the equals property: The value of the event's field will be compared to this value (case-insensitive) to
     * determine if the condition is met.
     * 
     * @param equals the equals value to set.
     * @return the AlertRuleLeafCondition object itself.
     */
    public AlertRuleLeafCondition withEquals(String equals) {
        this.equals = equals;
        return this;
    }

    /**
     * Get the containsAny property: The value of the event's field will be compared to the values in this array
     * (case-insensitive) to determine if the condition is met.
     * 
     * @return the containsAny value.
     */
    public List<String> containsAny() {
        return this.containsAny;
    }

    /**
     * Set the containsAny property: The value of the event's field will be compared to the values in this array
     * (case-insensitive) to determine if the condition is met.
     * 
     * @param containsAny the containsAny value to set.
     * @return the AlertRuleLeafCondition object itself.
     */
    public AlertRuleLeafCondition withContainsAny(List<String> containsAny) {
        this.containsAny = containsAny;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("field", this.field);
        jsonWriter.writeStringField("equals", this.equals);
        jsonWriter.writeArrayField("containsAny", this.containsAny, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AlertRuleLeafCondition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AlertRuleLeafCondition if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AlertRuleLeafCondition.
     */
    public static AlertRuleLeafCondition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlertRuleLeafCondition deserializedAlertRuleLeafCondition = new AlertRuleLeafCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("field".equals(fieldName)) {
                    deserializedAlertRuleLeafCondition.field = reader.getString();
                } else if ("equals".equals(fieldName)) {
                    deserializedAlertRuleLeafCondition.equals = reader.getString();
                } else if ("containsAny".equals(fieldName)) {
                    List<String> containsAny = reader.readArray(reader1 -> reader1.getString());
                    deserializedAlertRuleLeafCondition.containsAny = containsAny;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAlertRuleLeafCondition;
        });
    }
}
