// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction
 * in this case.
 */
@Fluent
public final class RuleEmailAction extends RuleAction {
    /*
     * specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
     */
    private String odataType = "Microsoft.Azure.Management.Insights.Models.RuleEmailAction";

    /*
     * Whether the administrators (service and co-administrators) of the service should be notified when the alert is
     * activated.
     */
    private Boolean sendToServiceOwners;

    /*
     * the list of administrator's custom email addresses to notify of the activation of the alert.
     */
    private List<String> customEmails;

    /**
     * Creates an instance of RuleEmailAction class.
     */
    public RuleEmailAction() {
    }

    /**
     * Get the odataType property: specifies the type of the action. There are two types of actions: RuleEmailAction and
     * RuleWebhookAction.
     * 
     * @return the odataType value.
     */
    @Override
    public String odataType() {
        return this.odataType;
    }

    /**
     * Get the sendToServiceOwners property: Whether the administrators (service and co-administrators) of the service
     * should be notified when the alert is activated.
     * 
     * @return the sendToServiceOwners value.
     */
    public Boolean sendToServiceOwners() {
        return this.sendToServiceOwners;
    }

    /**
     * Set the sendToServiceOwners property: Whether the administrators (service and co-administrators) of the service
     * should be notified when the alert is activated.
     * 
     * @param sendToServiceOwners the sendToServiceOwners value to set.
     * @return the RuleEmailAction object itself.
     */
    public RuleEmailAction withSendToServiceOwners(Boolean sendToServiceOwners) {
        this.sendToServiceOwners = sendToServiceOwners;
        return this;
    }

    /**
     * Get the customEmails property: the list of administrator's custom email addresses to notify of the activation of
     * the alert.
     * 
     * @return the customEmails value.
     */
    public List<String> customEmails() {
        return this.customEmails;
    }

    /**
     * Set the customEmails property: the list of administrator's custom email addresses to notify of the activation of
     * the alert.
     * 
     * @param customEmails the customEmails value to set.
     * @return the RuleEmailAction object itself.
     */
    public RuleEmailAction withCustomEmails(List<String> customEmails) {
        this.customEmails = customEmails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("odata.type", this.odataType);
        jsonWriter.writeBooleanField("sendToServiceOwners", this.sendToServiceOwners);
        jsonWriter.writeArrayField("customEmails", this.customEmails, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RuleEmailAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RuleEmailAction if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RuleEmailAction.
     */
    public static RuleEmailAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RuleEmailAction deserializedRuleEmailAction = new RuleEmailAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("odata.type".equals(fieldName)) {
                    deserializedRuleEmailAction.odataType = reader.getString();
                } else if ("sendToServiceOwners".equals(fieldName)) {
                    deserializedRuleEmailAction.sendToServiceOwners = reader.getNullable(JsonReader::getBoolean);
                } else if ("customEmails".equals(fieldName)) {
                    List<String> customEmails = reader.readArray(reader1 -> reader1.getString());
                    deserializedRuleEmailAction.customEmails = customEmails;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRuleEmailAction;
        });
    }
}
