// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Webhook notification of an autoscale event.
 */
@Fluent
public final class WebhookNotification implements JsonSerializable<WebhookNotification> {
    /*
     * the service address to receive the notification.
     */
    private String serviceUri;

    /*
     * a property bag of settings. This value can be empty.
     */
    private Map<String, String> properties;

    /**
     * Creates an instance of WebhookNotification class.
     */
    public WebhookNotification() {
    }

    /**
     * Get the serviceUri property: the service address to receive the notification.
     * 
     * @return the serviceUri value.
     */
    public String serviceUri() {
        return this.serviceUri;
    }

    /**
     * Set the serviceUri property: the service address to receive the notification.
     * 
     * @param serviceUri the serviceUri value to set.
     * @return the WebhookNotification object itself.
     */
    public WebhookNotification withServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    /**
     * Get the properties property: a property bag of settings. This value can be empty.
     * 
     * @return the properties value.
     */
    public Map<String, String> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: a property bag of settings. This value can be empty.
     * 
     * @param properties the properties value to set.
     * @return the WebhookNotification object itself.
     */
    public WebhookNotification withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceUri", this.serviceUri);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebhookNotification from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebhookNotification if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WebhookNotification.
     */
    public static WebhookNotification fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebhookNotification deserializedWebhookNotification = new WebhookNotification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceUri".equals(fieldName)) {
                    deserializedWebhookNotification.serviceUri = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    Map<String, String> properties = reader.readMap(reader1 -> reader1.getString());
                    deserializedWebhookNotification.properties = properties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebhookNotification;
        });
    }
}
