/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.DataCollectionEndpoint;
import com.azure.resourcemanager.monitor.models.DataCollectionEndpointConfigurationAccess;
import com.azure.resourcemanager.monitor.models.DataCollectionEndpointLogsIngestion;
import com.azure.resourcemanager.monitor.models.DataCollectionEndpointNetworkAcls;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionEndpointProvisioningState;
import java.io.IOException;

public final class DataCollectionEndpointResourceProperties
extends DataCollectionEndpoint {
    private KnownDataCollectionEndpointProvisioningState provisioningState;

    @Override
    public KnownDataCollectionEndpointProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public DataCollectionEndpointResourceProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public DataCollectionEndpointResourceProperties withImmutableId(String immutableId) {
        super.withImmutableId(immutableId);
        return this;
    }

    @Override
    public DataCollectionEndpointResourceProperties withConfigurationAccess(DataCollectionEndpointConfigurationAccess configurationAccess) {
        super.withConfigurationAccess(configurationAccess);
        return this;
    }

    @Override
    public DataCollectionEndpointResourceProperties withLogsIngestion(DataCollectionEndpointLogsIngestion logsIngestion) {
        super.withLogsIngestion(logsIngestion);
        return this;
    }

    @Override
    public DataCollectionEndpointResourceProperties withNetworkAcls(DataCollectionEndpointNetworkAcls networkAcls) {
        super.withNetworkAcls(networkAcls);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("immutableId", this.immutableId());
        jsonWriter.writeJsonField("configurationAccess", (JsonSerializable)this.configurationAccess());
        jsonWriter.writeJsonField("logsIngestion", (JsonSerializable)this.logsIngestion());
        jsonWriter.writeJsonField("networkAcls", (JsonSerializable)this.networkAcls());
        return jsonWriter.writeEndObject();
    }

    public static DataCollectionEndpointResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DataCollectionEndpointResourceProperties)jsonReader.readObject(reader -> {
            DataCollectionEndpointResourceProperties deserializedDataCollectionEndpointResourceProperties = new DataCollectionEndpointResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedDataCollectionEndpointResourceProperties.withDescription(reader.getString());
                    continue;
                }
                if ("immutableId".equals(fieldName)) {
                    deserializedDataCollectionEndpointResourceProperties.withImmutableId(reader.getString());
                    continue;
                }
                if ("configurationAccess".equals(fieldName)) {
                    deserializedDataCollectionEndpointResourceProperties.withConfigurationAccess(DataCollectionEndpointConfigurationAccess.fromJson(reader));
                    continue;
                }
                if ("logsIngestion".equals(fieldName)) {
                    deserializedDataCollectionEndpointResourceProperties.withLogsIngestion(DataCollectionEndpointLogsIngestion.fromJson(reader));
                    continue;
                }
                if ("networkAcls".equals(fieldName)) {
                    deserializedDataCollectionEndpointResourceProperties.withNetworkAcls(DataCollectionEndpointNetworkAcls.fromJson(reader));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDataCollectionEndpointResourceProperties.provisioningState = KnownDataCollectionEndpointProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataCollectionEndpointResourceProperties;
        });
    }
}

