/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.KnownWindowsEventLogDataSourceStreams;
import java.io.IOException;
import java.util.List;

public final class WindowsEventLogDataSource
implements JsonSerializable<WindowsEventLogDataSource> {
    private List<KnownWindowsEventLogDataSourceStreams> streams;
    private List<String> xPathQueries;
    private String name;

    public List<KnownWindowsEventLogDataSourceStreams> streams() {
        return this.streams;
    }

    public WindowsEventLogDataSource withStreams(List<KnownWindowsEventLogDataSourceStreams> streams) {
        this.streams = streams;
        return this;
    }

    public List<String> xPathQueries() {
        return this.xPathQueries;
    }

    public WindowsEventLogDataSource withXPathQueries(List<String> xPathQueries) {
        this.xPathQueries = xPathQueries;
        return this;
    }

    public String name() {
        return this.name;
    }

    public WindowsEventLogDataSource withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("streams", this.streams, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("xPathQueries", this.xPathQueries, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static WindowsEventLogDataSource fromJson(JsonReader jsonReader) throws IOException {
        return (WindowsEventLogDataSource)jsonReader.readObject(reader -> {
            WindowsEventLogDataSource deserializedWindowsEventLogDataSource = new WindowsEventLogDataSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("streams".equals(fieldName)) {
                    List streams;
                    deserializedWindowsEventLogDataSource.streams = streams = reader.readArray(reader1 -> KnownWindowsEventLogDataSourceStreams.fromString(reader1.getString()));
                    continue;
                }
                if ("xPathQueries".equals(fieldName)) {
                    List xPathQueries;
                    deserializedWindowsEventLogDataSource.xPathQueries = xPathQueries = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWindowsEventLogDataSource.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWindowsEventLogDataSource;
        });
    }
}

