// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A private link scoped resource.
 */
@Fluent
public final class ScopedResourceInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private ScopedResourceProperties innerProperties;

    /*
     * System data
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ScopedResourceInner class.
     */
    public ScopedResourceInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ScopedResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: System data.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the linkedResourceId property: The resource id of the scoped Azure monitor resource.
     * 
     * @return the linkedResourceId value.
     */
    public String linkedResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedResourceId();
    }

    /**
     * Set the linkedResourceId property: The resource id of the scoped Azure monitor resource.
     * 
     * @param linkedResourceId the linkedResourceId value to set.
     * @return the ScopedResourceInner object itself.
     */
    public ScopedResourceInner withLinkedResourceId(String linkedResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScopedResourceProperties();
        }
        this.innerProperties().withLinkedResourceId(linkedResourceId);
        return this;
    }

    /**
     * Get the provisioningState property: State of the private endpoint connection.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScopedResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScopedResourceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ScopedResourceInner.
     */
    public static ScopedResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScopedResourceInner deserializedScopedResourceInner = new ScopedResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedScopedResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedScopedResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedScopedResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedScopedResourceInner.innerProperties = ScopedResourceProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedScopedResourceInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScopedResourceInner;
        });
    }
}
