// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.AlertRulePatchProperties;
import java.io.IOException;
import java.util.Map;

/**
 * An Activity Log Alert rule object for the body of patch operations.
 */
@Fluent
public final class AlertRulePatchObject implements JsonSerializable<AlertRulePatchObject> {
    /*
     * The resource tags
     */
    private Map<String, String> tags;

    /*
     * The activity log alert settings for an update operation.
     */
    private AlertRulePatchProperties innerProperties;

    /**
     * Creates an instance of AlertRulePatchObject class.
     */
    public AlertRulePatchObject() {
    }

    /**
     * Get the tags property: The resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The resource tags.
     * 
     * @param tags the tags value to set.
     * @return the AlertRulePatchObject object itself.
     */
    public AlertRulePatchObject withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: The activity log alert settings for an update operation.
     * 
     * @return the innerProperties value.
     */
    private AlertRulePatchProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the enabled property: Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert
     * rule is not enabled, then none of its actions will be activated.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert
     * rule is not enabled, then none of its actions will be activated.
     * 
     * @param enabled the enabled value to set.
     * @return the AlertRulePatchObject object itself.
     */
    public AlertRulePatchObject withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertRulePatchProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AlertRulePatchObject from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AlertRulePatchObject if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AlertRulePatchObject.
     */
    public static AlertRulePatchObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlertRulePatchObject deserializedAlertRulePatchObject = new AlertRulePatchObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAlertRulePatchObject.tags = tags;
                } else if ("properties".equals(fieldName)) {
                    deserializedAlertRulePatchObject.innerProperties = AlertRulePatchProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAlertRulePatchObject;
        });
    }
}
