// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The Azure mobile App push notification receiver.
 */
@Fluent
public final class AzureAppPushReceiver implements JsonSerializable<AzureAppPushReceiver> {
    /*
     * The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
     */
    private String name;

    /*
     * The email address registered for the Azure mobile app.
     */
    private String emailAddress;

    /**
     * Creates an instance of AzureAppPushReceiver class.
     */
    public AzureAppPushReceiver() {
    }

    /**
     * Get the name property: The name of the Azure mobile app push receiver. Names must be unique across all receivers
     * within an action group.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the Azure mobile app push receiver. Names must be unique across all receivers
     * within an action group.
     * 
     * @param name the name value to set.
     * @return the AzureAppPushReceiver object itself.
     */
    public AzureAppPushReceiver withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the emailAddress property: The email address registered for the Azure mobile app.
     * 
     * @return the emailAddress value.
     */
    public String emailAddress() {
        return this.emailAddress;
    }

    /**
     * Set the emailAddress property: The email address registered for the Azure mobile app.
     * 
     * @param emailAddress the emailAddress value to set.
     * @return the AzureAppPushReceiver object itself.
     */
    public AzureAppPushReceiver withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model AzureAppPushReceiver"));
        }
        if (emailAddress() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property emailAddress in model AzureAppPushReceiver"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureAppPushReceiver.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("emailAddress", this.emailAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureAppPushReceiver from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureAppPushReceiver if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureAppPushReceiver.
     */
    public static AzureAppPushReceiver fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureAppPushReceiver deserializedAzureAppPushReceiver = new AzureAppPushReceiver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAzureAppPushReceiver.name = reader.getString();
                } else if ("emailAddress".equals(fieldName)) {
                    deserializedAzureAppPushReceiver.emailAddress = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureAppPushReceiver;
        });
    }
}
