// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure Monitor Metrics destination.
 */
@Fluent
public class AzureMonitorMetricsDestination implements JsonSerializable<AzureMonitorMetricsDestination> {
    /*
     * A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    private String name;

    /**
     * Creates an instance of AzureMonitorMetricsDestination class.
     */
    public AzureMonitorMetricsDestination() {
    }

    /**
     * Get the name property: A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     * 
     * @param name the name value to set.
     * @return the AzureMonitorMetricsDestination object itself.
     */
    public AzureMonitorMetricsDestination withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureMonitorMetricsDestination from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureMonitorMetricsDestination if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureMonitorMetricsDestination.
     */
    public static AzureMonitorMetricsDestination fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureMonitorMetricsDestination deserializedAzureMonitorMetricsDestination
                = new AzureMonitorMetricsDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAzureMonitorMetricsDestination.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureMonitorMetricsDestination;
        });
    }
}
