// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The endpoint used by clients to access their configuration.
 */
@Immutable
public final class DataCollectionEndpointConfigurationAccess extends ConfigurationAccessEndpointSpec {
    /*
     * The endpoint. This property is READ-ONLY.
     */
    private String endpoint;

    /**
     * Creates an instance of DataCollectionEndpointConfigurationAccess class.
     */
    public DataCollectionEndpointConfigurationAccess() {
    }

    /**
     * Get the endpoint property: The endpoint. This property is READ-ONLY.
     * 
     * @return the endpoint value.
     */
    @Override
    public String endpoint() {
        return this.endpoint;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataCollectionEndpointConfigurationAccess from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataCollectionEndpointConfigurationAccess if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataCollectionEndpointConfigurationAccess.
     */
    public static DataCollectionEndpointConfigurationAccess fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataCollectionEndpointConfigurationAccess deserializedDataCollectionEndpointConfigurationAccess
                = new DataCollectionEndpointConfigurationAccess();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endpoint".equals(fieldName)) {
                    deserializedDataCollectionEndpointConfigurationAccess.endpoint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataCollectionEndpointConfigurationAccess;
        });
    }
}
