// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
 * Collected from either Windows and Linux machines, depending on which extension is defined.
 */
@Fluent
public final class ExtensionDataSource implements JsonSerializable<ExtensionDataSource> {
    /*
     * List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will
     * be sent to.
     */
    private List<KnownExtensionDataSourceStreams> streams;

    /*
     * The name of the VM extension.
     */
    private String extensionName;

    /*
     * The extension settings. The format is specific for particular extension.
     */
    private Object extensionSettings;

    /*
     * The list of data sources this extension needs data from.
     */
    private List<String> inputDataSources;

    /*
     * A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    private String name;

    /**
     * Creates an instance of ExtensionDataSource class.
     */
    public ExtensionDataSource() {
    }

    /**
     * Get the streams property: List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will
     * be sent to.
     * 
     * @return the streams value.
     */
    public List<KnownExtensionDataSourceStreams> streams() {
        return this.streams;
    }

    /**
     * Set the streams property: List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will
     * be sent to.
     * 
     * @param streams the streams value to set.
     * @return the ExtensionDataSource object itself.
     */
    public ExtensionDataSource withStreams(List<KnownExtensionDataSourceStreams> streams) {
        this.streams = streams;
        return this;
    }

    /**
     * Get the extensionName property: The name of the VM extension.
     * 
     * @return the extensionName value.
     */
    public String extensionName() {
        return this.extensionName;
    }

    /**
     * Set the extensionName property: The name of the VM extension.
     * 
     * @param extensionName the extensionName value to set.
     * @return the ExtensionDataSource object itself.
     */
    public ExtensionDataSource withExtensionName(String extensionName) {
        this.extensionName = extensionName;
        return this;
    }

    /**
     * Get the extensionSettings property: The extension settings. The format is specific for particular extension.
     * 
     * @return the extensionSettings value.
     */
    public Object extensionSettings() {
        return this.extensionSettings;
    }

    /**
     * Set the extensionSettings property: The extension settings. The format is specific for particular extension.
     * 
     * @param extensionSettings the extensionSettings value to set.
     * @return the ExtensionDataSource object itself.
     */
    public ExtensionDataSource withExtensionSettings(Object extensionSettings) {
        this.extensionSettings = extensionSettings;
        return this;
    }

    /**
     * Get the inputDataSources property: The list of data sources this extension needs data from.
     * 
     * @return the inputDataSources value.
     */
    public List<String> inputDataSources() {
        return this.inputDataSources;
    }

    /**
     * Set the inputDataSources property: The list of data sources this extension needs data from.
     * 
     * @param inputDataSources the inputDataSources value to set.
     * @return the ExtensionDataSource object itself.
     */
    public ExtensionDataSource withInputDataSources(List<String> inputDataSources) {
        this.inputDataSources = inputDataSources;
        return this;
    }

    /**
     * Get the name property: A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     * 
     * @param name the name value to set.
     * @return the ExtensionDataSource object itself.
     */
    public ExtensionDataSource withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (extensionName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property extensionName in model ExtensionDataSource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExtensionDataSource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("extensionName", this.extensionName);
        jsonWriter.writeArrayField("streams", this.streams,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeUntypedField("extensionSettings", this.extensionSettings);
        jsonWriter.writeArrayField("inputDataSources", this.inputDataSources,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExtensionDataSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExtensionDataSource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExtensionDataSource.
     */
    public static ExtensionDataSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExtensionDataSource deserializedExtensionDataSource = new ExtensionDataSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("extensionName".equals(fieldName)) {
                    deserializedExtensionDataSource.extensionName = reader.getString();
                } else if ("streams".equals(fieldName)) {
                    List<KnownExtensionDataSourceStreams> streams
                        = reader.readArray(reader1 -> KnownExtensionDataSourceStreams.fromString(reader1.getString()));
                    deserializedExtensionDataSource.streams = streams;
                } else if ("extensionSettings".equals(fieldName)) {
                    deserializedExtensionDataSource.extensionSettings = reader.readUntyped();
                } else if ("inputDataSources".equals(fieldName)) {
                    List<String> inputDataSources = reader.readArray(reader1 -> reader1.getString());
                    deserializedExtensionDataSource.inputDataSources = inputDataSources;
                } else if ("name".equals(fieldName)) {
                    deserializedExtensionDataSource.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExtensionDataSource;
        });
    }
}
