/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.ScaleRuleInner;
import com.azure.resourcemanager.monitor.models.Recurrence;
import com.azure.resourcemanager.monitor.models.ScaleCapacity;
import com.azure.resourcemanager.monitor.models.TimeWindow;
import java.io.IOException;
import java.util.List;

public final class AutoscaleProfileInner
implements JsonSerializable<AutoscaleProfileInner> {
    private String name;
    private ScaleCapacity capacity;
    private List<ScaleRuleInner> rules;
    private TimeWindow fixedDate;
    private Recurrence recurrence;
    private static final ClientLogger LOGGER = new ClientLogger(AutoscaleProfileInner.class);

    public String name() {
        return this.name;
    }

    public AutoscaleProfileInner withName(String name) {
        this.name = name;
        return this;
    }

    public ScaleCapacity capacity() {
        return this.capacity;
    }

    public AutoscaleProfileInner withCapacity(ScaleCapacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public List<ScaleRuleInner> rules() {
        return this.rules;
    }

    public AutoscaleProfileInner withRules(List<ScaleRuleInner> rules) {
        this.rules = rules;
        return this;
    }

    public TimeWindow fixedDate() {
        return this.fixedDate;
    }

    public AutoscaleProfileInner withFixedDate(TimeWindow fixedDate) {
        this.fixedDate = fixedDate;
        return this;
    }

    public Recurrence recurrence() {
        return this.recurrence;
    }

    public AutoscaleProfileInner withRecurrence(Recurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model AutoscaleProfileInner"));
        }
        if (this.capacity() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property capacity in model AutoscaleProfileInner"));
        }
        this.capacity().validate();
        if (this.rules() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rules in model AutoscaleProfileInner"));
        }
        this.rules().forEach(e -> e.validate());
        if (this.fixedDate() != null) {
            this.fixedDate().validate();
        }
        if (this.recurrence() != null) {
            this.recurrence().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("capacity", (JsonSerializable)this.capacity);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("fixedDate", (JsonSerializable)this.fixedDate);
        jsonWriter.writeJsonField("recurrence", (JsonSerializable)this.recurrence);
        return jsonWriter.writeEndObject();
    }

    public static AutoscaleProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return (AutoscaleProfileInner)jsonReader.readObject(reader -> {
            AutoscaleProfileInner deserializedAutoscaleProfileInner = new AutoscaleProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAutoscaleProfileInner.name = reader.getString();
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedAutoscaleProfileInner.capacity = ScaleCapacity.fromJson(reader);
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedAutoscaleProfileInner.rules = rules = reader.readArray(reader1 -> ScaleRuleInner.fromJson(reader1));
                    continue;
                }
                if ("fixedDate".equals(fieldName)) {
                    deserializedAutoscaleProfileInner.fixedDate = TimeWindow.fromJson(reader);
                    continue;
                }
                if ("recurrence".equals(fieldName)) {
                    deserializedAutoscaleProfileInner.recurrence = Recurrence.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoscaleProfileInner;
        });
    }
}

