/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureAppPushReceiver
implements JsonSerializable<AzureAppPushReceiver> {
    private String name;
    private String emailAddress;
    private static final ClientLogger LOGGER = new ClientLogger(AzureAppPushReceiver.class);

    public String name() {
        return this.name;
    }

    public AzureAppPushReceiver withName(String name) {
        this.name = name;
        return this;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public AzureAppPushReceiver withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model AzureAppPushReceiver"));
        }
        if (this.emailAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property emailAddress in model AzureAppPushReceiver"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("emailAddress", this.emailAddress);
        return jsonWriter.writeEndObject();
    }

    public static AzureAppPushReceiver fromJson(JsonReader jsonReader) throws IOException {
        return (AzureAppPushReceiver)jsonReader.readObject(reader -> {
            AzureAppPushReceiver deserializedAzureAppPushReceiver = new AzureAppPushReceiver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureAppPushReceiver.name = reader.getString();
                    continue;
                }
                if ("emailAddress".equals(fieldName)) {
                    deserializedAzureAppPushReceiver.emailAddress = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureAppPushReceiver;
        });
    }
}

