/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.EventDataInner;
import java.io.IOException;
import java.util.List;

public final class EventDataCollection
implements JsonSerializable<EventDataCollection> {
    private List<EventDataInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(EventDataCollection.class);

    public List<EventDataInner> value() {
        return this.value;
    }

    public EventDataCollection withValue(List<EventDataInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public EventDataCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model EventDataCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static EventDataCollection fromJson(JsonReader jsonReader) throws IOException {
        return (EventDataCollection)jsonReader.readObject(reader -> {
            EventDataCollection deserializedEventDataCollection = new EventDataCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedEventDataCollection.value = value = reader.readArray(reader1 -> EventDataInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedEventDataCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventDataCollection;
        });
    }
}

