// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.Baseline;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** The response to a calculate baseline call. */
@Fluent
public final class CalculateBaselineResponseInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CalculateBaselineResponseInner.class);

    /*
     * the resource type of the baseline resource.
     */
    @JsonProperty(value = "type", required = true)
    private String type;

    /*
     * the array of timestamps of the baselines.
     */
    @JsonProperty(value = "timestamps")
    private List<OffsetDateTime> timestamps;

    /*
     * the baseline values for each sensitivity.
     */
    @JsonProperty(value = "baseline", required = true)
    private List<Baseline> baseline;

    /**
     * Get the type property: the resource type of the baseline resource.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: the resource type of the baseline resource.
     *
     * @param type the type value to set.
     * @return the CalculateBaselineResponseInner object itself.
     */
    public CalculateBaselineResponseInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the timestamps property: the array of timestamps of the baselines.
     *
     * @return the timestamps value.
     */
    public List<OffsetDateTime> timestamps() {
        return this.timestamps;
    }

    /**
     * Set the timestamps property: the array of timestamps of the baselines.
     *
     * @param timestamps the timestamps value to set.
     * @return the CalculateBaselineResponseInner object itself.
     */
    public CalculateBaselineResponseInner withTimestamps(List<OffsetDateTime> timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    /**
     * Get the baseline property: the baseline values for each sensitivity.
     *
     * @return the baseline value.
     */
    public List<Baseline> baseline() {
        return this.baseline;
    }

    /**
     * Set the baseline property: the baseline values for each sensitivity.
     *
     * @param baseline the baseline value to set.
     * @return the CalculateBaselineResponseInner object itself.
     */
    public CalculateBaselineResponseInner withBaseline(List<Baseline> baseline) {
        this.baseline = baseline;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property type in model CalculateBaselineResponseInner"));
        }
        if (baseline() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property baseline in model CalculateBaselineResponseInner"));
        } else {
            baseline().forEach(e -> e.validate());
        }
    }
}
