// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.CategoryType;
import com.azure.resourcemanager.monitor.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The diagnostic settings category resource. */
@JsonFlatten
@Fluent
public class DiagnosticSettingsCategoryResourceInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DiagnosticSettingsCategoryResourceInner.class);

    /*
     * The type of the diagnostic settings category.
     */
    @JsonProperty(value = "properties.categoryType")
    private CategoryType categoryType;

    /**
     * Get the categoryType property: The type of the diagnostic settings category.
     *
     * @return the categoryType value.
     */
    public CategoryType categoryType() {
        return this.categoryType;
    }

    /**
     * Set the categoryType property: The type of the diagnostic settings category.
     *
     * @param categoryType the categoryType value to set.
     * @return the DiagnosticSettingsCategoryResourceInner object itself.
     */
    public DiagnosticSettingsCategoryResourceInner withCategoryType(CategoryType categoryType) {
        this.categoryType = categoryType;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
