// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** Action descriptor. */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "odata\\.type",
    defaultImpl = Action.class)
@JsonTypeName("Action")
@JsonSubTypes({
    @JsonSubTypes.Type(
        name =
            "Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts"
                + ".Resources.ScheduledQueryRules.AlertingAction",
        value = AlertingAction.class),
    @JsonSubTypes.Type(
        name =
            "Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts"
                + ".Resources.ScheduledQueryRules.LogToMetricAction",
        value = LogToMetricAction.class)
})
@JsonFlatten
@Immutable
public class Action {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(Action.class);

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
