// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.fluent.models.AutoscaleProfileInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** The autoscale setting object for patch operations. */
@JsonFlatten
@Fluent
public class AutoscaleSettingResourcePatch {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AutoscaleSettingResourcePatch.class);

    /*
     * Resource tags
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /*
     * the collection of automatic scaling profiles that specify different
     * scaling parameters for different time periods. A maximum of 20 profiles
     * can be specified.
     */
    @JsonProperty(value = "properties.profiles")
    private List<AutoscaleProfileInner> profiles;

    /*
     * the collection of notifications.
     */
    @JsonProperty(value = "properties.notifications")
    private List<AutoscaleNotification> notifications;

    /*
     * the enabled flag. Specifies whether automatic scaling is enabled for the
     * resource. The default value is 'true'.
     */
    @JsonProperty(value = "properties.enabled")
    private Boolean enabled;

    /*
     * the name of the autoscale setting.
     */
    @JsonProperty(value = "properties.name")
    private String name;

    /*
     * the resource identifier of the resource that the autoscale setting
     * should be added to.
     */
    @JsonProperty(value = "properties.targetResourceUri")
    private String targetResourceUri;

    /**
     * Get the tags property: Resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     *
     * @param tags the tags value to set.
     * @return the AutoscaleSettingResourcePatch object itself.
     */
    public AutoscaleSettingResourcePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the profiles property: the collection of automatic scaling profiles that specify different scaling parameters
     * for different time periods. A maximum of 20 profiles can be specified.
     *
     * @return the profiles value.
     */
    public List<AutoscaleProfileInner> profiles() {
        return this.profiles;
    }

    /**
     * Set the profiles property: the collection of automatic scaling profiles that specify different scaling parameters
     * for different time periods. A maximum of 20 profiles can be specified.
     *
     * @param profiles the profiles value to set.
     * @return the AutoscaleSettingResourcePatch object itself.
     */
    public AutoscaleSettingResourcePatch withProfiles(List<AutoscaleProfileInner> profiles) {
        this.profiles = profiles;
        return this;
    }

    /**
     * Get the notifications property: the collection of notifications.
     *
     * @return the notifications value.
     */
    public List<AutoscaleNotification> notifications() {
        return this.notifications;
    }

    /**
     * Set the notifications property: the collection of notifications.
     *
     * @param notifications the notifications value to set.
     * @return the AutoscaleSettingResourcePatch object itself.
     */
    public AutoscaleSettingResourcePatch withNotifications(List<AutoscaleNotification> notifications) {
        this.notifications = notifications;
        return this;
    }

    /**
     * Get the enabled property: the enabled flag. Specifies whether automatic scaling is enabled for the resource. The
     * default value is 'true'.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: the enabled flag. Specifies whether automatic scaling is enabled for the resource. The
     * default value is 'true'.
     *
     * @param enabled the enabled value to set.
     * @return the AutoscaleSettingResourcePatch object itself.
     */
    public AutoscaleSettingResourcePatch withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the name property: the name of the autoscale setting.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: the name of the autoscale setting.
     *
     * @param name the name value to set.
     * @return the AutoscaleSettingResourcePatch object itself.
     */
    public AutoscaleSettingResourcePatch withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the targetResourceUri property: the resource identifier of the resource that the autoscale setting should be
     * added to.
     *
     * @return the targetResourceUri value.
     */
    public String targetResourceUri() {
        return this.targetResourceUri;
    }

    /**
     * Set the targetResourceUri property: the resource identifier of the resource that the autoscale setting should be
     * added to.
     *
     * @param targetResourceUri the targetResourceUri value to set.
     * @return the AutoscaleSettingResourcePatch object itself.
     */
    public AutoscaleSettingResourcePatch withTargetResourceUri(String targetResourceUri) {
        this.targetResourceUri = targetResourceUri;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (profiles() != null) {
            profiles().forEach(e -> e.validate());
        }
        if (notifications() != null) {
            notifications().forEach(e -> e.validate());
        }
    }
}
