/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.fluent.models.BaselineMetadataValueInner;
import com.azure.resourcemanager.monitor.fluent.models.LocalizableStringInner;
import com.azure.resourcemanager.monitor.models.Baseline;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class BaselineResponseInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(BaselineResponseInner.class);
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="name", access=JsonProperty.Access.WRITE_ONLY)
    private LocalizableStringInner name;
    @JsonProperty(value="properties.timespan")
    private String timespan;
    @JsonProperty(value="properties.interval")
    private Duration interval;
    @JsonProperty(value="properties.aggregation")
    private String aggregation;
    @JsonProperty(value="properties.timestamps")
    private List<OffsetDateTime> timestamps;
    @JsonProperty(value="properties.baseline")
    private List<Baseline> baseline;
    @JsonProperty(value="properties.metadata")
    private List<BaselineMetadataValueInner> metadata;

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public LocalizableStringInner name() {
        return this.name;
    }

    public String timespan() {
        return this.timespan;
    }

    public BaselineResponseInner withTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    public Duration interval() {
        return this.interval;
    }

    public BaselineResponseInner withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public String aggregation() {
        return this.aggregation;
    }

    public BaselineResponseInner withAggregation(String aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    public List<OffsetDateTime> timestamps() {
        return this.timestamps;
    }

    public BaselineResponseInner withTimestamps(List<OffsetDateTime> timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public List<Baseline> baseline() {
        return this.baseline;
    }

    public BaselineResponseInner withBaseline(List<Baseline> baseline) {
        this.baseline = baseline;
        return this;
    }

    public List<BaselineMetadataValueInner> metadata() {
        return this.metadata;
    }

    public BaselineResponseInner withMetadata(List<BaselineMetadataValueInner> metadata) {
        this.metadata = metadata;
        return this;
    }

    public void validate() {
        if (this.name() != null) {
            this.name().validate();
        }
        if (this.baseline() != null) {
            this.baseline().forEach(e -> e.validate());
        }
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
    }
}

