/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.Action;
import com.azure.resourcemanager.monitor.models.Enabled;
import com.azure.resourcemanager.monitor.models.ProvisioningState;
import com.azure.resourcemanager.monitor.models.Schedule;
import com.azure.resourcemanager.monitor.models.Source;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonFlatten
public class LogSearchRuleResourceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LogSearchRuleResourceInner.class);
    @JsonProperty(value="properties.description")
    private String description;
    @JsonProperty(value="properties.enabled")
    private Enabled enabled;
    @JsonProperty(value="properties.lastUpdatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUpdatedTime;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.source", required=true)
    private Source source;
    @JsonProperty(value="properties.schedule")
    private Schedule schedule;
    @JsonProperty(value="properties.action", required=true)
    private Action action;

    public String description() {
        return this.description;
    }

    public LogSearchRuleResourceInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public Enabled enabled() {
        return this.enabled;
    }

    public LogSearchRuleResourceInner withEnabled(Enabled enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Source source() {
        return this.source;
    }

    public LogSearchRuleResourceInner withSource(Source source) {
        this.source = source;
        return this;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public LogSearchRuleResourceInner withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public Action action() {
        return this.action;
    }

    public LogSearchRuleResourceInner withAction(Action action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property source in model LogSearchRuleResourceInner"));
        }
        this.source().validate();
        if (this.schedule() != null) {
            this.schedule().validate();
        }
        if (this.action() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property action in model LogSearchRuleResourceInner"));
        }
        this.action().validate();
    }
}

