/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.DiagnosticSettingsCategoriesClient;
import com.azure.resourcemanager.monitor.fluent.models.DiagnosticSettingsCategoryResourceCollectionInner;
import com.azure.resourcemanager.monitor.fluent.models.DiagnosticSettingsCategoryResourceInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import reactor.core.publisher.Mono;

public final class DiagnosticSettingsCategoriesClientImpl
implements DiagnosticSettingsCategoriesClient {
    private final ClientLogger logger = new ClientLogger(DiagnosticSettingsCategoriesClientImpl.class);
    private final DiagnosticSettingsCategoriesService service;
    private final MonitorClientImpl client;

    DiagnosticSettingsCategoriesClientImpl(MonitorClientImpl client) {
        this.service = (DiagnosticSettingsCategoriesService)RestProxy.create(DiagnosticSettingsCategoriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DiagnosticSettingsCategoryResourceInner>> getWithResponseAsync(String resourceUri, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String apiVersion = "2017-05-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceUri, "2017-05-01-preview", name, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DiagnosticSettingsCategoryResourceInner>> getWithResponseAsync(String resourceUri, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String apiVersion = "2017-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceUri, "2017-05-01-preview", name, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DiagnosticSettingsCategoryResourceInner> getAsync(String resourceUri, String name) {
        return this.getWithResponseAsync(resourceUri, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DiagnosticSettingsCategoryResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiagnosticSettingsCategoryResourceInner get(String resourceUri, String name) {
        return (DiagnosticSettingsCategoryResourceInner)((Object)this.getAsync(resourceUri, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DiagnosticSettingsCategoryResourceInner> getWithResponse(String resourceUri, String name, Context context) {
        return (Response)this.getWithResponseAsync(resourceUri, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DiagnosticSettingsCategoryResourceCollectionInner>> listWithResponseAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2017-05-01-preview";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceUri, "2017-05-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DiagnosticSettingsCategoryResourceCollectionInner>> listWithResponseAsync(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2017-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceUri, "2017-05-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DiagnosticSettingsCategoryResourceCollectionInner> listAsync(String resourceUri) {
        return this.listWithResponseAsync(resourceUri).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DiagnosticSettingsCategoryResourceCollectionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiagnosticSettingsCategoryResourceCollectionInner list(String resourceUri) {
        return (DiagnosticSettingsCategoryResourceCollectionInner)this.listAsync(resourceUri).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DiagnosticSettingsCategoryResourceCollectionInner> listWithResponse(String resourceUri, Context context) {
        return (Response)this.listWithResponseAsync(resourceUri, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientDiagnos")
    private static interface DiagnosticSettingsCategoriesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/microsoft.insights/diagnosticSettingsCategories/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DiagnosticSettingsCategoryResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="name") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/microsoft.insights/diagnosticSettingsCategories")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DiagnosticSettingsCategoryResourceCollectionInner>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, Context var4);
    }
}

