/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.Sensitivity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Baseline {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Baseline.class);
    @JsonProperty(value="sensitivity", required=true)
    private Sensitivity sensitivity;
    @JsonProperty(value="lowThresholds", required=true)
    private List<Double> lowThresholds;
    @JsonProperty(value="highThresholds", required=true)
    private List<Double> highThresholds;

    public Sensitivity sensitivity() {
        return this.sensitivity;
    }

    public Baseline withSensitivity(Sensitivity sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    public List<Double> lowThresholds() {
        return this.lowThresholds;
    }

    public Baseline withLowThresholds(List<Double> lowThresholds) {
        this.lowThresholds = lowThresholds;
        return this;
    }

    public List<Double> highThresholds() {
        return this.highThresholds;
    }

    public Baseline withHighThresholds(List<Double> highThresholds) {
        this.highThresholds = highThresholds;
        return this;
    }

    public void validate() {
        if (this.sensitivity() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sensitivity in model Baseline"));
        }
        if (this.lowThresholds() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property lowThresholds in model Baseline"));
        }
        if (this.highThresholds() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property highThresholds in model Baseline"));
        }
    }
}

