/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class TimeSeriesInformation {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TimeSeriesInformation.class);
    @JsonProperty(value="sensitivities", required=true)
    private List<String> sensitivities;
    @JsonProperty(value="values", required=true)
    private List<Double> values;
    @JsonProperty(value="timestamps")
    private List<OffsetDateTime> timestamps;

    public List<String> sensitivities() {
        return this.sensitivities;
    }

    public TimeSeriesInformation withSensitivities(List<String> sensitivities) {
        this.sensitivities = sensitivities;
        return this;
    }

    public List<Double> values() {
        return this.values;
    }

    public TimeSeriesInformation withValues(List<Double> values) {
        this.values = values;
        return this;
    }

    public List<OffsetDateTime> timestamps() {
        return this.timestamps;
    }

    public TimeSeriesInformation withTimestamps(List<OffsetDateTime> timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public void validate() {
        if (this.sensitivities() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sensitivities in model TimeSeriesInformation"));
        }
        if (this.values() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property values in model TimeSeriesInformation"));
        }
    }
}

