// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.AccessModeSettings;
import java.io.IOException;
import java.util.List;

/**
 * Properties that define a Azure Monitor PrivateLinkScope resource.
 */
@Fluent
public final class AzureMonitorPrivateLinkScopeProperties
    implements JsonSerializable<AzureMonitorPrivateLinkScopeProperties> {
    /*
     * Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is
     * defined. Users cannot change this value but are able to read from it. Values will include Provisioning
     * ,Succeeded, Canceled and Failed.
     */
    private String provisioningState;

    /*
     * List of private endpoint connections.
     */
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    /*
     * Access mode settings
     */
    private AccessModeSettings accessModeSettings;

    /**
     * Creates an instance of AzureMonitorPrivateLinkScopeProperties class.
     */
    public AzureMonitorPrivateLinkScopeProperties() {
    }

    /**
     * Get the provisioningState property: Current state of this PrivateLinkScope: whether or not is has been
     * provisioned within the resource group it is defined. Users cannot change this value but are able to read from it.
     * Values will include Provisioning ,Succeeded, Canceled and Failed.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the accessModeSettings property: Access mode settings.
     * 
     * @return the accessModeSettings value.
     */
    public AccessModeSettings accessModeSettings() {
        return this.accessModeSettings;
    }

    /**
     * Set the accessModeSettings property: Access mode settings.
     * 
     * @param accessModeSettings the accessModeSettings value to set.
     * @return the AzureMonitorPrivateLinkScopeProperties object itself.
     */
    public AzureMonitorPrivateLinkScopeProperties withAccessModeSettings(AccessModeSettings accessModeSettings) {
        this.accessModeSettings = accessModeSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
        if (accessModeSettings() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property accessModeSettings in model AzureMonitorPrivateLinkScopeProperties"));
        } else {
            accessModeSettings().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorPrivateLinkScopeProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("accessModeSettings", this.accessModeSettings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureMonitorPrivateLinkScopeProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureMonitorPrivateLinkScopeProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureMonitorPrivateLinkScopeProperties.
     */
    public static AzureMonitorPrivateLinkScopeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureMonitorPrivateLinkScopeProperties deserializedAzureMonitorPrivateLinkScopeProperties
                = new AzureMonitorPrivateLinkScopeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accessModeSettings".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeProperties.accessModeSettings
                        = AccessModeSettings.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeProperties.provisioningState = reader.getString();
                } else if ("privateEndpointConnections".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> privateEndpointConnections
                        = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedAzureMonitorPrivateLinkScopeProperties.privateEndpointConnections
                        = privateEndpointConnections;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureMonitorPrivateLinkScopeProperties;
        });
    }
}
