// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.TimeSeriesBaseline;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

/**
 * The response to a metric baselines query.
 */
@Fluent
public final class MetricBaselinesProperties implements JsonSerializable<MetricBaselinesProperties> {
    /*
     * The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by
     * '/'. This may be adjusted in the future and returned back from what was originally requested.
     */
    private String timespan;

    /*
     * The interval (window size) for which the metric data was returned in. This may be adjusted in the future and
     * returned back from what was originally requested. This is not present if a metadata request was made.
     */
    private Duration interval;

    /*
     * The namespace of the metrics been queried.
     */
    private String namespace;

    /*
     * The baseline for each time series that was queried.
     */
    private List<TimeSeriesBaseline> baselines;

    /**
     * Creates an instance of MetricBaselinesProperties class.
     */
    public MetricBaselinesProperties() {
    }

    /**
     * Get the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     * 
     * @return the timespan value.
     */
    public String timespan() {
        return this.timespan;
    }

    /**
     * Set the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     * 
     * @param timespan the timespan value to set.
     * @return the MetricBaselinesProperties object itself.
     */
    public MetricBaselinesProperties withTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    /**
     * Get the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     * 
     * @return the interval value.
     */
    public Duration interval() {
        return this.interval;
    }

    /**
     * Set the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     * 
     * @param interval the interval value to set.
     * @return the MetricBaselinesProperties object itself.
     */
    public MetricBaselinesProperties withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the namespace property: The namespace of the metrics been queried.
     * 
     * @return the namespace value.
     */
    public String namespace() {
        return this.namespace;
    }

    /**
     * Set the namespace property: The namespace of the metrics been queried.
     * 
     * @param namespace the namespace value to set.
     * @return the MetricBaselinesProperties object itself.
     */
    public MetricBaselinesProperties withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    /**
     * Get the baselines property: The baseline for each time series that was queried.
     * 
     * @return the baselines value.
     */
    public List<TimeSeriesBaseline> baselines() {
        return this.baselines;
    }

    /**
     * Set the baselines property: The baseline for each time series that was queried.
     * 
     * @param baselines the baselines value to set.
     * @return the MetricBaselinesProperties object itself.
     */
    public MetricBaselinesProperties withBaselines(List<TimeSeriesBaseline> baselines) {
        this.baselines = baselines;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timespan() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property timespan in model MetricBaselinesProperties"));
        }
        if (interval() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property interval in model MetricBaselinesProperties"));
        }
        if (baselines() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property baselines in model MetricBaselinesProperties"));
        } else {
            baselines().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MetricBaselinesProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timespan", this.timespan);
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays(this.interval));
        jsonWriter.writeArrayField("baselines", this.baselines, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("namespace", this.namespace);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricBaselinesProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricBaselinesProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MetricBaselinesProperties.
     */
    public static MetricBaselinesProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricBaselinesProperties deserializedMetricBaselinesProperties = new MetricBaselinesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timespan".equals(fieldName)) {
                    deserializedMetricBaselinesProperties.timespan = reader.getString();
                } else if ("interval".equals(fieldName)) {
                    deserializedMetricBaselinesProperties.interval
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("baselines".equals(fieldName)) {
                    List<TimeSeriesBaseline> baselines
                        = reader.readArray(reader1 -> TimeSeriesBaseline.fromJson(reader1));
                    deserializedMetricBaselinesProperties.baselines = baselines;
                } else if ("namespace".equals(fieldName)) {
                    deserializedMetricBaselinesProperties.namespace = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricBaselinesProperties;
        });
    }
}
