// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.TimeSeriesElement;
import com.azure.resourcemanager.monitor.models.Unit;
import java.io.IOException;
import java.util.List;

/**
 * The result data of a query.
 */
@Fluent
public final class MetricInner implements JsonSerializable<MetricInner> {
    /*
     * the metric Id.
     */
    private String id;

    /*
     * the resource type of the metric resource.
     */
    private String type;

    /*
     * the name and the display name of the metric, i.e. it is localizable string.
     */
    private LocalizableStringInner name;

    /*
     * Detailed description of this metric.
     */
    private String displayDescription;

    /*
     * 'Success' or the error details on query failures for this metric.
     */
    private String errorCode;

    /*
     * Error message encountered querying this specific metric.
     */
    private String errorMessage;

    /*
     * The unit of the metric.
     */
    private Unit unit;

    /*
     * the time series returned when a data query is performed.
     */
    private List<TimeSeriesElement> timeseries;

    /**
     * Creates an instance of MetricInner class.
     */
    public MetricInner() {
    }

    /**
     * Get the id property: the metric Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: the metric Id.
     * 
     * @param id the id value to set.
     * @return the MetricInner object itself.
     */
    public MetricInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: the resource type of the metric resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: the resource type of the metric resource.
     * 
     * @param type the type value to set.
     * @return the MetricInner object itself.
     */
    public MetricInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the name property: the name and the display name of the metric, i.e. it is localizable string.
     * 
     * @return the name value.
     */
    public LocalizableStringInner name() {
        return this.name;
    }

    /**
     * Set the name property: the name and the display name of the metric, i.e. it is localizable string.
     * 
     * @param name the name value to set.
     * @return the MetricInner object itself.
     */
    public MetricInner withName(LocalizableStringInner name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayDescription property: Detailed description of this metric.
     * 
     * @return the displayDescription value.
     */
    public String displayDescription() {
        return this.displayDescription;
    }

    /**
     * Set the displayDescription property: Detailed description of this metric.
     * 
     * @param displayDescription the displayDescription value to set.
     * @return the MetricInner object itself.
     */
    public MetricInner withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    /**
     * Get the errorCode property: 'Success' or the error details on query failures for this metric.
     * 
     * @return the errorCode value.
     */
    public String errorCode() {
        return this.errorCode;
    }

    /**
     * Set the errorCode property: 'Success' or the error details on query failures for this metric.
     * 
     * @param errorCode the errorCode value to set.
     * @return the MetricInner object itself.
     */
    public MetricInner withErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    /**
     * Get the errorMessage property: Error message encountered querying this specific metric.
     * 
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.errorMessage;
    }

    /**
     * Set the errorMessage property: Error message encountered querying this specific metric.
     * 
     * @param errorMessage the errorMessage value to set.
     * @return the MetricInner object itself.
     */
    public MetricInner withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    /**
     * Get the unit property: The unit of the metric.
     * 
     * @return the unit value.
     */
    public Unit unit() {
        return this.unit;
    }

    /**
     * Set the unit property: The unit of the metric.
     * 
     * @param unit the unit value to set.
     * @return the MetricInner object itself.
     */
    public MetricInner withUnit(Unit unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the timeseries property: the time series returned when a data query is performed.
     * 
     * @return the timeseries value.
     */
    public List<TimeSeriesElement> timeseries() {
        return this.timeseries;
    }

    /**
     * Set the timeseries property: the time series returned when a data query is performed.
     * 
     * @param timeseries the timeseries value to set.
     * @return the MetricInner object itself.
     */
    public MetricInner withTimeseries(List<TimeSeriesElement> timeseries) {
        this.timeseries = timeseries;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model MetricInner"));
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model MetricInner"));
        }
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model MetricInner"));
        } else {
            name().validate();
        }
        if (unit() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property unit in model MetricInner"));
        }
        if (timeseries() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property timeseries in model MetricInner"));
        } else {
            timeseries().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MetricInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("name", this.name);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeArrayField("timeseries", this.timeseries, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MetricInner.
     */
    public static MetricInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricInner deserializedMetricInner = new MetricInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMetricInner.id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMetricInner.type = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMetricInner.name = LocalizableStringInner.fromJson(reader);
                } else if ("unit".equals(fieldName)) {
                    deserializedMetricInner.unit = Unit.fromString(reader.getString());
                } else if ("timeseries".equals(fieldName)) {
                    List<TimeSeriesElement> timeseries
                        = reader.readArray(reader1 -> TimeSeriesElement.fromJson(reader1));
                    deserializedMetricInner.timeseries = timeseries;
                } else if ("displayDescription".equals(fieldName)) {
                    deserializedMetricInner.displayDescription = reader.getString();
                } else if ("errorCode".equals(fieldName)) {
                    deserializedMetricInner.errorCode = reader.getString();
                } else if ("errorMessage".equals(fieldName)) {
                    deserializedMetricInner.errorMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricInner;
        });
    }
}
