// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An Activity Log Alert rule condition that is met when all its member conditions are met.
 */
@Fluent
public final class ActivityLogAlertAllOfCondition implements JsonSerializable<ActivityLogAlertAllOfCondition> {
    /*
     * The list of Activity Log Alert rule conditions.
     */
    private List<ActivityLogAlertLeafCondition> allOf;

    /**
     * Creates an instance of ActivityLogAlertAllOfCondition class.
     */
    public ActivityLogAlertAllOfCondition() {
    }

    /**
     * Get the allOf property: The list of Activity Log Alert rule conditions.
     * 
     * @return the allOf value.
     */
    public List<ActivityLogAlertLeafCondition> allOf() {
        return this.allOf;
    }

    /**
     * Set the allOf property: The list of Activity Log Alert rule conditions.
     * 
     * @param allOf the allOf value to set.
     * @return the ActivityLogAlertAllOfCondition object itself.
     */
    public ActivityLogAlertAllOfCondition withAllOf(List<ActivityLogAlertLeafCondition> allOf) {
        this.allOf = allOf;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (allOf() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property allOf in model ActivityLogAlertAllOfCondition"));
        } else {
            allOf().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ActivityLogAlertAllOfCondition.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allOf", this.allOf, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ActivityLogAlertAllOfCondition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ActivityLogAlertAllOfCondition if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ActivityLogAlertAllOfCondition.
     */
    public static ActivityLogAlertAllOfCondition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ActivityLogAlertAllOfCondition deserializedActivityLogAlertAllOfCondition
                = new ActivityLogAlertAllOfCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allOf".equals(fieldName)) {
                    List<ActivityLogAlertLeafCondition> allOf
                        = reader.readArray(reader1 -> ActivityLogAlertLeafCondition.fromJson(reader1));
                    deserializedActivityLogAlertAllOfCondition.allOf = allOf;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedActivityLogAlertAllOfCondition;
        });
    }
}
