/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.LogProfileProperties;
import com.azure.resourcemanager.monitor.models.RetentionPolicy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class LogProfileResourceInner
extends Resource {
    private LogProfileProperties innerProperties = new LogProfileProperties();
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(LogProfileResourceInner.class);

    private LogProfileProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public LogProfileResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public LogProfileResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String storageAccountId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountId();
    }

    public LogProfileResourceInner withStorageAccountId(String storageAccountId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogProfileProperties();
        }
        this.innerProperties().withStorageAccountId(storageAccountId);
        return this;
    }

    public String serviceBusRuleId() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBusRuleId();
    }

    public LogProfileResourceInner withServiceBusRuleId(String serviceBusRuleId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogProfileProperties();
        }
        this.innerProperties().withServiceBusRuleId(serviceBusRuleId);
        return this;
    }

    public List<String> locations() {
        return this.innerProperties() == null ? null : this.innerProperties().locations();
    }

    public LogProfileResourceInner withLocations(List<String> locations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogProfileProperties();
        }
        this.innerProperties().withLocations(locations);
        return this;
    }

    public List<String> categories() {
        return this.innerProperties() == null ? null : this.innerProperties().categories();
    }

    public LogProfileResourceInner withCategories(List<String> categories) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogProfileProperties();
        }
        this.innerProperties().withCategories(categories);
        return this;
    }

    public RetentionPolicy retentionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionPolicy();
    }

    public LogProfileResourceInner withRetentionPolicy(RetentionPolicy retentionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogProfileProperties();
        }
        this.innerProperties().withRetentionPolicy(retentionPolicy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model LogProfileResourceInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static LogProfileResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (LogProfileResourceInner)((Object)jsonReader.readObject(reader -> {
            LogProfileResourceInner deserializedLogProfileResourceInner = new LogProfileResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLogProfileResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLogProfileResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLogProfileResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedLogProfileResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedLogProfileResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLogProfileResourceInner.innerProperties = LogProfileProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogProfileResourceInner;
        }));
    }
}

