/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.LogProfileProperties;
import com.azure.resourcemanager.monitor.models.RetentionPolicy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class LogProfileResourcePatch
implements JsonSerializable<LogProfileResourcePatch> {
    private Map<String, String> tags;
    private LogProfileProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public LogProfileResourcePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private LogProfileProperties innerProperties() {
        return this.innerProperties;
    }

    public String storageAccountId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountId();
    }

    public LogProfileResourcePatch withStorageAccountId(String storageAccountId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogProfileProperties();
        }
        this.innerProperties().withStorageAccountId(storageAccountId);
        return this;
    }

    public String serviceBusRuleId() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBusRuleId();
    }

    public LogProfileResourcePatch withServiceBusRuleId(String serviceBusRuleId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogProfileProperties();
        }
        this.innerProperties().withServiceBusRuleId(serviceBusRuleId);
        return this;
    }

    public List<String> locations() {
        return this.innerProperties() == null ? null : this.innerProperties().locations();
    }

    public LogProfileResourcePatch withLocations(List<String> locations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogProfileProperties();
        }
        this.innerProperties().withLocations(locations);
        return this;
    }

    public List<String> categories() {
        return this.innerProperties() == null ? null : this.innerProperties().categories();
    }

    public LogProfileResourcePatch withCategories(List<String> categories) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogProfileProperties();
        }
        this.innerProperties().withCategories(categories);
        return this;
    }

    public RetentionPolicy retentionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionPolicy();
    }

    public LogProfileResourcePatch withRetentionPolicy(RetentionPolicy retentionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogProfileProperties();
        }
        this.innerProperties().withRetentionPolicy(retentionPolicy);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static LogProfileResourcePatch fromJson(JsonReader jsonReader) throws IOException {
        return (LogProfileResourcePatch)jsonReader.readObject(reader -> {
            LogProfileResourcePatch deserializedLogProfileResourcePatch = new LogProfileResourcePatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedLogProfileResourcePatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLogProfileResourcePatch.innerProperties = LogProfileProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogProfileResourcePatch;
        });
    }
}

