// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Definition of which streams are sent to which destinations.
 */
@Fluent
public final class DataFlow implements JsonSerializable<DataFlow> {
    /*
     * List of streams for this data flow.
     */
    private List<KnownDataFlowStreams> streams;

    /*
     * List of destinations for this data flow.
     */
    private List<String> destinations;

    /*
     * The KQL query to transform stream data.
     */
    private String transformKql;

    /*
     * The output stream of the transform. Only required if the transform changes data to a different stream.
     */
    private String outputStream;

    /**
     * Creates an instance of DataFlow class.
     */
    public DataFlow() {
    }

    /**
     * Get the streams property: List of streams for this data flow.
     * 
     * @return the streams value.
     */
    public List<KnownDataFlowStreams> streams() {
        return this.streams;
    }

    /**
     * Set the streams property: List of streams for this data flow.
     * 
     * @param streams the streams value to set.
     * @return the DataFlow object itself.
     */
    public DataFlow withStreams(List<KnownDataFlowStreams> streams) {
        this.streams = streams;
        return this;
    }

    /**
     * Get the destinations property: List of destinations for this data flow.
     * 
     * @return the destinations value.
     */
    public List<String> destinations() {
        return this.destinations;
    }

    /**
     * Set the destinations property: List of destinations for this data flow.
     * 
     * @param destinations the destinations value to set.
     * @return the DataFlow object itself.
     */
    public DataFlow withDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    /**
     * Get the transformKql property: The KQL query to transform stream data.
     * 
     * @return the transformKql value.
     */
    public String transformKql() {
        return this.transformKql;
    }

    /**
     * Set the transformKql property: The KQL query to transform stream data.
     * 
     * @param transformKql the transformKql value to set.
     * @return the DataFlow object itself.
     */
    public DataFlow withTransformKql(String transformKql) {
        this.transformKql = transformKql;
        return this;
    }

    /**
     * Get the outputStream property: The output stream of the transform. Only required if the transform changes data to
     * a different stream.
     * 
     * @return the outputStream value.
     */
    public String outputStream() {
        return this.outputStream;
    }

    /**
     * Set the outputStream property: The output stream of the transform. Only required if the transform changes data to
     * a different stream.
     * 
     * @param outputStream the outputStream value to set.
     * @return the DataFlow object itself.
     */
    public DataFlow withOutputStream(String outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("streams", this.streams,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("destinations", this.destinations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("transformKql", this.transformKql);
        jsonWriter.writeStringField("outputStream", this.outputStream);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataFlow from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataFlow if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the DataFlow.
     */
    public static DataFlow fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataFlow deserializedDataFlow = new DataFlow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("streams".equals(fieldName)) {
                    List<KnownDataFlowStreams> streams
                        = reader.readArray(reader1 -> KnownDataFlowStreams.fromString(reader1.getString()));
                    deserializedDataFlow.streams = streams;
                } else if ("destinations".equals(fieldName)) {
                    List<String> destinations = reader.readArray(reader1 -> reader1.getString());
                    deserializedDataFlow.destinations = destinations;
                } else if ("transformKql".equals(fieldName)) {
                    deserializedDataFlow.transformKql = reader.getString();
                } else if ("outputStream".equals(fieldName)) {
                    deserializedDataFlow.outputStream = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataFlow;
        });
    }
}
