// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Settings for different log file formats.
 */
@Fluent
public class LogFileSettings implements JsonSerializable<LogFileSettings> {
    /*
     * Text settings
     */
    private LogFileSettingsText text;

    /**
     * Creates an instance of LogFileSettings class.
     */
    public LogFileSettings() {
    }

    /**
     * Get the text property: Text settings.
     * 
     * @return the text value.
     */
    public LogFileSettingsText text() {
        return this.text;
    }

    /**
     * Set the text property: Text settings.
     * 
     * @param text the text value to set.
     * @return the LogFileSettings object itself.
     */
    public LogFileSettings withText(LogFileSettingsText text) {
        this.text = text;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (text() != null) {
            text().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("text", this.text);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogFileSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogFileSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LogFileSettings.
     */
    public static LogFileSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogFileSettings deserializedLogFileSettings = new LogFileSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedLogFileSettings.text = LogFileSettingsText.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogFileSettings;
        });
    }
}
