/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.PredictiveValue;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class PredictiveResponseInner
implements JsonSerializable<PredictiveResponseInner> {
    private String timespan;
    private Duration interval;
    private String metricName;
    private String targetResourceId;
    private List<PredictiveValue> data;

    public String timespan() {
        return this.timespan;
    }

    public PredictiveResponseInner withTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    public Duration interval() {
        return this.interval;
    }

    public PredictiveResponseInner withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public String metricName() {
        return this.metricName;
    }

    public PredictiveResponseInner withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public PredictiveResponseInner withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public List<PredictiveValue> data() {
        return this.data;
    }

    public PredictiveResponseInner withData(List<PredictiveValue> data) {
        this.data = data;
        return this;
    }

    public void validate() {
        if (this.data() != null) {
            this.data().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timespan", this.timespan);
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays((Duration)this.interval));
        jsonWriter.writeStringField("metricName", this.metricName);
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PredictiveResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (PredictiveResponseInner)jsonReader.readObject(reader -> {
            PredictiveResponseInner deserializedPredictiveResponseInner = new PredictiveResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timespan".equals(fieldName)) {
                    deserializedPredictiveResponseInner.timespan = reader.getString();
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedPredictiveResponseInner.interval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("metricName".equals(fieldName)) {
                    deserializedPredictiveResponseInner.metricName = reader.getString();
                    continue;
                }
                if ("targetResourceId".equals(fieldName)) {
                    deserializedPredictiveResponseInner.targetResourceId = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    List data;
                    deserializedPredictiveResponseInner.data = data = reader.readArray(reader1 -> PredictiveValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPredictiveResponseInner;
        });
    }
}

