// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.ActionDetail;
import com.azure.resourcemanager.monitor.models.Context;
import java.io.IOException;
import java.util.List;

/**
 * The details of the test notification results.
 */
@Fluent
public final class TestNotificationDetailsResponseInner
    implements JsonSerializable<TestNotificationDetailsResponseInner> {
    /*
     * The context info
     */
    private Context context;

    /*
     * The overall state
     */
    private String state;

    /*
     * The completed time
     */
    private String completedTime;

    /*
     * The created time
     */
    private String createdTime;

    /*
     * The list of action detail
     */
    private List<ActionDetail> actionDetails;

    /**
     * Creates an instance of TestNotificationDetailsResponseInner class.
     */
    public TestNotificationDetailsResponseInner() {
    }

    /**
     * Get the context property: The context info.
     * 
     * @return the context value.
     */
    public Context context() {
        return this.context;
    }

    /**
     * Set the context property: The context info.
     * 
     * @param context the context value to set.
     * @return the TestNotificationDetailsResponseInner object itself.
     */
    public TestNotificationDetailsResponseInner withContext(Context context) {
        this.context = context;
        return this;
    }

    /**
     * Get the state property: The overall state.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The overall state.
     * 
     * @param state the state value to set.
     * @return the TestNotificationDetailsResponseInner object itself.
     */
    public TestNotificationDetailsResponseInner withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the completedTime property: The completed time.
     * 
     * @return the completedTime value.
     */
    public String completedTime() {
        return this.completedTime;
    }

    /**
     * Set the completedTime property: The completed time.
     * 
     * @param completedTime the completedTime value to set.
     * @return the TestNotificationDetailsResponseInner object itself.
     */
    public TestNotificationDetailsResponseInner withCompletedTime(String completedTime) {
        this.completedTime = completedTime;
        return this;
    }

    /**
     * Get the createdTime property: The created time.
     * 
     * @return the createdTime value.
     */
    public String createdTime() {
        return this.createdTime;
    }

    /**
     * Set the createdTime property: The created time.
     * 
     * @param createdTime the createdTime value to set.
     * @return the TestNotificationDetailsResponseInner object itself.
     */
    public TestNotificationDetailsResponseInner withCreatedTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    /**
     * Get the actionDetails property: The list of action detail.
     * 
     * @return the actionDetails value.
     */
    public List<ActionDetail> actionDetails() {
        return this.actionDetails;
    }

    /**
     * Set the actionDetails property: The list of action detail.
     * 
     * @param actionDetails the actionDetails value to set.
     * @return the TestNotificationDetailsResponseInner object itself.
     */
    public TestNotificationDetailsResponseInner withActionDetails(List<ActionDetail> actionDetails) {
        this.actionDetails = actionDetails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (context() != null) {
            context().validate();
        }
        if (state() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property state in model TestNotificationDetailsResponseInner"));
        }
        if (actionDetails() != null) {
            actionDetails().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TestNotificationDetailsResponseInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeJsonField("context", this.context);
        jsonWriter.writeStringField("completedTime", this.completedTime);
        jsonWriter.writeStringField("createdTime", this.createdTime);
        jsonWriter.writeArrayField("actionDetails", this.actionDetails, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TestNotificationDetailsResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TestNotificationDetailsResponseInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TestNotificationDetailsResponseInner.
     */
    public static TestNotificationDetailsResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TestNotificationDetailsResponseInner deserializedTestNotificationDetailsResponseInner
                = new TestNotificationDetailsResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedTestNotificationDetailsResponseInner.state = reader.getString();
                } else if ("context".equals(fieldName)) {
                    deserializedTestNotificationDetailsResponseInner.context = Context.fromJson(reader);
                } else if ("completedTime".equals(fieldName)) {
                    deserializedTestNotificationDetailsResponseInner.completedTime = reader.getString();
                } else if ("createdTime".equals(fieldName)) {
                    deserializedTestNotificationDetailsResponseInner.createdTime = reader.getString();
                } else if ("actionDetails".equals(fieldName)) {
                    List<ActionDetail> actionDetails = reader.readArray(reader1 -> ActionDetail.fromJson(reader1));
                    deserializedTestNotificationDetailsResponseInner.actionDetails = actionDetails;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTestNotificationDetailsResponseInner;
        });
    }
}
