/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.AutoscaleSettingResourceInner;
import java.io.IOException;
import java.util.List;

public final class AutoscaleSettingResourceCollection
implements JsonSerializable<AutoscaleSettingResourceCollection> {
    private List<AutoscaleSettingResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(AutoscaleSettingResourceCollection.class);

    public List<AutoscaleSettingResourceInner> value() {
        return this.value;
    }

    public AutoscaleSettingResourceCollection withValue(List<AutoscaleSettingResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public AutoscaleSettingResourceCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model AutoscaleSettingResourceCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static AutoscaleSettingResourceCollection fromJson(JsonReader jsonReader) throws IOException {
        return (AutoscaleSettingResourceCollection)jsonReader.readObject(reader -> {
            AutoscaleSettingResourceCollection deserializedAutoscaleSettingResourceCollection = new AutoscaleSettingResourceCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedAutoscaleSettingResourceCollection.value = value = reader.readArray(reader1 -> AutoscaleSettingResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoscaleSettingResourceCollection;
        });
    }
}

