// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.ScheduledQueryRuleProperties;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;

/**
 * The scheduled query rule resource for patch operations.
 */
@Fluent
public final class ScheduledQueryRuleResourcePatch implements JsonSerializable<ScheduledQueryRuleResourcePatch> {
    /*
     * Resource tags
     */
    private Map<String, String> tags;

    /*
     * The scheduled query rule properties of the resource.
     */
    private ScheduledQueryRuleProperties innerProperties;

    /**
     * Creates an instance of ScheduledQueryRuleResourcePatch class.
     */
    public ScheduledQueryRuleResourcePatch() {
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: The scheduled query rule properties of the resource.
     * 
     * @return the innerProperties value.
     */
    private ScheduledQueryRuleProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the createdWithApiVersion property: The api-version used when creating this alert rule.
     * 
     * @return the createdWithApiVersion value.
     */
    public String createdWithApiVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().createdWithApiVersion();
    }

    /**
     * Get the isLegacyLogAnalyticsRule property: True if alert rule is legacy Log Analytic rule.
     * 
     * @return the isLegacyLogAnalyticsRule value.
     */
    public Boolean isLegacyLogAnalyticsRule() {
        return this.innerProperties() == null ? null : this.innerProperties().isLegacyLogAnalyticsRule();
    }

    /**
     * Get the description property: The description of the scheduled query rule.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The description of the scheduled query rule.
     * 
     * @param description the description value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the displayName property: The display name of the alert rule.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: The display name of the alert rule.
     * 
     * @param displayName the displayName value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the severity property: Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest.
     * Relevant and required only for rules of the kind LogAlert.
     * 
     * @return the severity value.
     */
    public AlertSeverity severity() {
        return this.innerProperties() == null ? null : this.innerProperties().severity();
    }

    /**
     * Set the severity property: Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest.
     * Relevant and required only for rules of the kind LogAlert.
     * 
     * @param severity the severity value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withSeverity(AlertSeverity severity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withSeverity(severity);
        return this;
    }

    /**
     * Get the enabled property: The flag which indicates whether this scheduled query rule is enabled. Value should be
     * true or false.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: The flag which indicates whether this scheduled query rule is enabled. Value should be
     * true or false.
     * 
     * @param enabled the enabled value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Get the scopes property: The list of resource id's that this scheduled query rule is scoped to.
     * 
     * @return the scopes value.
     */
    public List<String> scopes() {
        return this.innerProperties() == null ? null : this.innerProperties().scopes();
    }

    /**
     * Set the scopes property: The list of resource id's that this scheduled query rule is scoped to.
     * 
     * @param scopes the scopes value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withScopes(List<String> scopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withScopes(scopes);
        return this;
    }

    /**
     * Get the evaluationFrequency property: How often the scheduled query rule is evaluated represented in ISO 8601
     * duration format. Relevant and required only for rules of the kind LogAlert.
     * 
     * @return the evaluationFrequency value.
     */
    public Duration evaluationFrequency() {
        return this.innerProperties() == null ? null : this.innerProperties().evaluationFrequency();
    }

    /**
     * Set the evaluationFrequency property: How often the scheduled query rule is evaluated represented in ISO 8601
     * duration format. Relevant and required only for rules of the kind LogAlert.
     * 
     * @param evaluationFrequency the evaluationFrequency value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withEvaluationFrequency(Duration evaluationFrequency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withEvaluationFrequency(evaluationFrequency);
        return this;
    }

    /**
     * Get the windowSize property: The period of time (in ISO 8601 duration format) on which the Alert query will be
     * executed (bin size). Relevant and required only for rules of the kind LogAlert.
     * 
     * @return the windowSize value.
     */
    public Duration windowSize() {
        return this.innerProperties() == null ? null : this.innerProperties().windowSize();
    }

    /**
     * Set the windowSize property: The period of time (in ISO 8601 duration format) on which the Alert query will be
     * executed (bin size). Relevant and required only for rules of the kind LogAlert.
     * 
     * @param windowSize the windowSize value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withWindowSize(Duration windowSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withWindowSize(windowSize);
        return this;
    }

    /**
     * Get the overrideQueryTimeRange property: If specified then overrides the query time range (default is
     * WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
     * 
     * @return the overrideQueryTimeRange value.
     */
    public Duration overrideQueryTimeRange() {
        return this.innerProperties() == null ? null : this.innerProperties().overrideQueryTimeRange();
    }

    /**
     * Set the overrideQueryTimeRange property: If specified then overrides the query time range (default is
     * WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
     * 
     * @param overrideQueryTimeRange the overrideQueryTimeRange value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withOverrideQueryTimeRange(Duration overrideQueryTimeRange) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withOverrideQueryTimeRange(overrideQueryTimeRange);
        return this;
    }

    /**
     * Get the targetResourceTypes property: List of resource type of the target resource(s) on which the alert is
     * created/updated. For example if the scope is a resource group and targetResourceTypes is
     * Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource
     * group which meet the alert criteria. Relevant only for rules of the kind LogAlert.
     * 
     * @return the targetResourceTypes value.
     */
    public List<String> targetResourceTypes() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceTypes();
    }

    /**
     * Set the targetResourceTypes property: List of resource type of the target resource(s) on which the alert is
     * created/updated. For example if the scope is a resource group and targetResourceTypes is
     * Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource
     * group which meet the alert criteria. Relevant only for rules of the kind LogAlert.
     * 
     * @param targetResourceTypes the targetResourceTypes value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withTargetResourceTypes(List<String> targetResourceTypes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withTargetResourceTypes(targetResourceTypes);
        return this;
    }

    /**
     * Get the criteria property: The rule criteria that defines the conditions of the scheduled query rule.
     * 
     * @return the criteria value.
     */
    public ScheduledQueryRuleCriteria criteria() {
        return this.innerProperties() == null ? null : this.innerProperties().criteria();
    }

    /**
     * Set the criteria property: The rule criteria that defines the conditions of the scheduled query rule.
     * 
     * @param criteria the criteria value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withCriteria(ScheduledQueryRuleCriteria criteria) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withCriteria(criteria);
        return this;
    }

    /**
     * Get the muteActionsDuration property: Mute actions for the chosen period of time (in ISO 8601 duration format)
     * after the alert is fired. Relevant only for rules of the kind LogAlert.
     * 
     * @return the muteActionsDuration value.
     */
    public Duration muteActionsDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().muteActionsDuration();
    }

    /**
     * Set the muteActionsDuration property: Mute actions for the chosen period of time (in ISO 8601 duration format)
     * after the alert is fired. Relevant only for rules of the kind LogAlert.
     * 
     * @param muteActionsDuration the muteActionsDuration value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withMuteActionsDuration(Duration muteActionsDuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withMuteActionsDuration(muteActionsDuration);
        return this;
    }

    /**
     * Get the actions property: Actions to invoke when the alert fires.
     * 
     * @return the actions value.
     */
    public Actions actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    /**
     * Set the actions property: Actions to invoke when the alert fires.
     * 
     * @param actions the actions value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withActions(Actions actions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withActions(actions);
        return this;
    }

    /**
     * Get the isWorkspaceAlertsStorageConfigured property: The flag which indicates whether this scheduled query rule
     * has been configured to be stored in the customer's storage. The default is false.
     * 
     * @return the isWorkspaceAlertsStorageConfigured value.
     */
    public Boolean isWorkspaceAlertsStorageConfigured() {
        return this.innerProperties() == null ? null : this.innerProperties().isWorkspaceAlertsStorageConfigured();
    }

    /**
     * Get the checkWorkspaceAlertsStorageConfigured property: The flag which indicates whether this scheduled query
     * rule should be stored in the customer's storage. The default is false. Relevant only for rules of the kind
     * LogAlert.
     * 
     * @return the checkWorkspaceAlertsStorageConfigured value.
     */
    public Boolean checkWorkspaceAlertsStorageConfigured() {
        return this.innerProperties() == null ? null : this.innerProperties().checkWorkspaceAlertsStorageConfigured();
    }

    /**
     * Set the checkWorkspaceAlertsStorageConfigured property: The flag which indicates whether this scheduled query
     * rule should be stored in the customer's storage. The default is false. Relevant only for rules of the kind
     * LogAlert.
     * 
     * @param checkWorkspaceAlertsStorageConfigured the checkWorkspaceAlertsStorageConfigured value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch
        withCheckWorkspaceAlertsStorageConfigured(Boolean checkWorkspaceAlertsStorageConfigured) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withCheckWorkspaceAlertsStorageConfigured(checkWorkspaceAlertsStorageConfigured);
        return this;
    }

    /**
     * Get the skipQueryValidation property: The flag which indicates whether the provided query should be validated or
     * not. The default is false. Relevant only for rules of the kind LogAlert.
     * 
     * @return the skipQueryValidation value.
     */
    public Boolean skipQueryValidation() {
        return this.innerProperties() == null ? null : this.innerProperties().skipQueryValidation();
    }

    /**
     * Set the skipQueryValidation property: The flag which indicates whether the provided query should be validated or
     * not. The default is false. Relevant only for rules of the kind LogAlert.
     * 
     * @param skipQueryValidation the skipQueryValidation value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withSkipQueryValidation(Boolean skipQueryValidation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withSkipQueryValidation(skipQueryValidation);
        return this;
    }

    /**
     * Get the autoMitigate property: The flag that indicates whether the alert should be automatically resolved or not.
     * The default is true. Relevant only for rules of the kind LogAlert.
     * 
     * @return the autoMitigate value.
     */
    public Boolean autoMitigate() {
        return this.innerProperties() == null ? null : this.innerProperties().autoMitigate();
    }

    /**
     * Set the autoMitigate property: The flag that indicates whether the alert should be automatically resolved or not.
     * The default is true. Relevant only for rules of the kind LogAlert.
     * 
     * @param autoMitigate the autoMitigate value to set.
     * @return the ScheduledQueryRuleResourcePatch object itself.
     */
    public ScheduledQueryRuleResourcePatch withAutoMitigate(Boolean autoMitigate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduledQueryRuleProperties();
        }
        this.innerProperties().withAutoMitigate(autoMitigate);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScheduledQueryRuleResourcePatch from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScheduledQueryRuleResourcePatch if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScheduledQueryRuleResourcePatch.
     */
    public static ScheduledQueryRuleResourcePatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScheduledQueryRuleResourcePatch deserializedScheduledQueryRuleResourcePatch
                = new ScheduledQueryRuleResourcePatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedScheduledQueryRuleResourcePatch.tags = tags;
                } else if ("properties".equals(fieldName)) {
                    deserializedScheduledQueryRuleResourcePatch.innerProperties
                        = ScheduledQueryRuleProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScheduledQueryRuleResourcePatch;
        });
    }
}
