// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Declaration of a custom stream.
 */
@Fluent
public final class StreamDeclaration implements JsonSerializable<StreamDeclaration> {
    /*
     * List of columns used by data in this stream.
     */
    private List<ColumnDefinition> columns;

    /**
     * Creates an instance of StreamDeclaration class.
     */
    public StreamDeclaration() {
    }

    /**
     * Get the columns property: List of columns used by data in this stream.
     * 
     * @return the columns value.
     */
    public List<ColumnDefinition> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: List of columns used by data in this stream.
     * 
     * @param columns the columns value to set.
     * @return the StreamDeclaration object itself.
     */
    public StreamDeclaration withColumns(List<ColumnDefinition> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StreamDeclaration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StreamDeclaration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the StreamDeclaration.
     */
    public static StreamDeclaration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StreamDeclaration deserializedStreamDeclaration = new StreamDeclaration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("columns".equals(fieldName)) {
                    List<ColumnDefinition> columns = reader.readArray(reader1 -> ColumnDefinition.fromJson(reader1));
                    deserializedStreamDeclaration.columns = columns;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStreamDeclaration;
        });
    }
}
