// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

/**
 * Aggregation operators allowed in a rule.
 */
public enum TimeAggregationOperator {
    /**
     * Enum value Average.
     */
    AVERAGE("Average"),

    /**
     * Enum value Minimum.
     */
    MINIMUM("Minimum"),

    /**
     * Enum value Maximum.
     */
    MAXIMUM("Maximum"),

    /**
     * Enum value Total.
     */
    TOTAL("Total"),

    /**
     * Enum value Last.
     */
    LAST("Last");

    /**
     * The actual serialized value for a TimeAggregationOperator instance.
     */
    private final String value;

    TimeAggregationOperator(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a TimeAggregationOperator instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed TimeAggregationOperator object, or null if unable to parse.
     */
    public static TimeAggregationOperator fromString(String value) {
        if (value == null) {
            return null;
        }
        TimeAggregationOperator[] items = TimeAggregationOperator.values();
        for (TimeAggregationOperator item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
