/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.KnownSyslogDataSourceFacilityNames;
import com.azure.resourcemanager.monitor.models.KnownSyslogDataSourceLogLevels;
import com.azure.resourcemanager.monitor.models.KnownSyslogDataSourceStreams;
import java.io.IOException;
import java.util.List;

public final class SyslogDataSource
implements JsonSerializable<SyslogDataSource> {
    private List<KnownSyslogDataSourceStreams> streams;
    private List<KnownSyslogDataSourceFacilityNames> facilityNames;
    private List<KnownSyslogDataSourceLogLevels> logLevels;
    private String name;

    public List<KnownSyslogDataSourceStreams> streams() {
        return this.streams;
    }

    public SyslogDataSource withStreams(List<KnownSyslogDataSourceStreams> streams) {
        this.streams = streams;
        return this;
    }

    public List<KnownSyslogDataSourceFacilityNames> facilityNames() {
        return this.facilityNames;
    }

    public SyslogDataSource withFacilityNames(List<KnownSyslogDataSourceFacilityNames> facilityNames) {
        this.facilityNames = facilityNames;
        return this;
    }

    public List<KnownSyslogDataSourceLogLevels> logLevels() {
        return this.logLevels;
    }

    public SyslogDataSource withLogLevels(List<KnownSyslogDataSourceLogLevels> logLevels) {
        this.logLevels = logLevels;
        return this;
    }

    public String name() {
        return this.name;
    }

    public SyslogDataSource withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("streams", this.streams, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("facilityNames", this.facilityNames, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("logLevels", this.logLevels, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static SyslogDataSource fromJson(JsonReader jsonReader) throws IOException {
        return (SyslogDataSource)jsonReader.readObject(reader -> {
            SyslogDataSource deserializedSyslogDataSource = new SyslogDataSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("streams".equals(fieldName)) {
                    List streams;
                    deserializedSyslogDataSource.streams = streams = reader.readArray(reader1 -> KnownSyslogDataSourceStreams.fromString(reader1.getString()));
                    continue;
                }
                if ("facilityNames".equals(fieldName)) {
                    List facilityNames;
                    deserializedSyslogDataSource.facilityNames = facilityNames = reader.readArray(reader1 -> KnownSyslogDataSourceFacilityNames.fromString(reader1.getString()));
                    continue;
                }
                if ("logLevels".equals(fieldName)) {
                    List logLevels;
                    deserializedSyslogDataSource.logLevels = logLevels = reader.readArray(reader1 -> KnownSyslogDataSourceLogLevels.fromString(reader1.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSyslogDataSource.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSyslogDataSource;
        });
    }
}

