// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure Monitor Metrics destination.
 */
@Fluent
public final class DestinationsSpecAzureMonitorMetrics extends AzureMonitorMetricsDestination {
    /**
     * Creates an instance of DestinationsSpecAzureMonitorMetrics class.
     */
    public DestinationsSpecAzureMonitorMetrics() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DestinationsSpecAzureMonitorMetrics withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", name());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DestinationsSpecAzureMonitorMetrics from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DestinationsSpecAzureMonitorMetrics if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DestinationsSpecAzureMonitorMetrics.
     */
    public static DestinationsSpecAzureMonitorMetrics fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DestinationsSpecAzureMonitorMetrics deserializedDestinationsSpecAzureMonitorMetrics
                = new DestinationsSpecAzureMonitorMetrics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDestinationsSpecAzureMonitorMetrics.withName(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDestinationsSpecAzureMonitorMetrics;
        });
    }
}
