/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.ActionGroupsClient;
import com.azure.resourcemanager.monitor.fluent.ActivityLogAlertsClient;
import com.azure.resourcemanager.monitor.fluent.ActivityLogsClient;
import com.azure.resourcemanager.monitor.fluent.AlertRuleIncidentsClient;
import com.azure.resourcemanager.monitor.fluent.AlertRulesClient;
import com.azure.resourcemanager.monitor.fluent.AutoscaleSettingsClient;
import com.azure.resourcemanager.monitor.fluent.BaselinesClient;
import com.azure.resourcemanager.monitor.fluent.DiagnosticSettingsCategoriesClient;
import com.azure.resourcemanager.monitor.fluent.DiagnosticSettingsClient;
import com.azure.resourcemanager.monitor.fluent.EventCategoriesClient;
import com.azure.resourcemanager.monitor.fluent.LogProfilesClient;
import com.azure.resourcemanager.monitor.fluent.MetricAlertsClient;
import com.azure.resourcemanager.monitor.fluent.MetricAlertsStatusClient;
import com.azure.resourcemanager.monitor.fluent.MetricBaselinesClient;
import com.azure.resourcemanager.monitor.fluent.MetricDefinitionsClient;
import com.azure.resourcemanager.monitor.fluent.MetricNamespacesClient;
import com.azure.resourcemanager.monitor.fluent.MetricsClient;
import com.azure.resourcemanager.monitor.fluent.MonitorClient;
import com.azure.resourcemanager.monitor.fluent.OperationsClient;
import com.azure.resourcemanager.monitor.fluent.ScheduledQueryRulesClient;
import com.azure.resourcemanager.monitor.fluent.TenantActivityLogsClient;
import com.azure.resourcemanager.monitor.fluent.VMInsightsClient;
import com.azure.resourcemanager.monitor.implementation.ActionGroupsClientImpl;
import com.azure.resourcemanager.monitor.implementation.ActivityLogAlertsClientImpl;
import com.azure.resourcemanager.monitor.implementation.ActivityLogsClientImpl;
import com.azure.resourcemanager.monitor.implementation.AlertRuleIncidentsClientImpl;
import com.azure.resourcemanager.monitor.implementation.AlertRulesClientImpl;
import com.azure.resourcemanager.monitor.implementation.AutoscaleSettingsClientImpl;
import com.azure.resourcemanager.monitor.implementation.BaselinesClientImpl;
import com.azure.resourcemanager.monitor.implementation.DiagnosticSettingsCategoriesClientImpl;
import com.azure.resourcemanager.monitor.implementation.DiagnosticSettingsClientImpl;
import com.azure.resourcemanager.monitor.implementation.EventCategoriesClientImpl;
import com.azure.resourcemanager.monitor.implementation.LogProfilesClientImpl;
import com.azure.resourcemanager.monitor.implementation.MetricAlertsClientImpl;
import com.azure.resourcemanager.monitor.implementation.MetricAlertsStatusClientImpl;
import com.azure.resourcemanager.monitor.implementation.MetricBaselinesClientImpl;
import com.azure.resourcemanager.monitor.implementation.MetricDefinitionsClientImpl;
import com.azure.resourcemanager.monitor.implementation.MetricNamespacesClientImpl;
import com.azure.resourcemanager.monitor.implementation.MetricsClientImpl;
import com.azure.resourcemanager.monitor.implementation.MonitorClientBuilder;
import com.azure.resourcemanager.monitor.implementation.OperationsClientImpl;
import com.azure.resourcemanager.monitor.implementation.ScheduledQueryRulesClientImpl;
import com.azure.resourcemanager.monitor.implementation.TenantActivityLogsClientImpl;
import com.azure.resourcemanager.monitor.implementation.VMInsightsClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

@ServiceClient(builder=MonitorClientBuilder.class)
public final class MonitorClientImpl
extends AzureServiceClient
implements MonitorClient {
    private final ClientLogger logger = new ClientLogger(MonitorClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final AutoscaleSettingsClient autoscaleSettings;
    private final OperationsClient operations;
    private final AlertRuleIncidentsClient alertRuleIncidents;
    private final AlertRulesClient alertRules;
    private final LogProfilesClient logProfiles;
    private final DiagnosticSettingsClient diagnosticSettings;
    private final DiagnosticSettingsCategoriesClient diagnosticSettingsCategories;
    private final ActionGroupsClient actionGroups;
    private final ActivityLogAlertsClient activityLogAlerts;
    private final ActivityLogsClient activityLogs;
    private final EventCategoriesClient eventCategories;
    private final TenantActivityLogsClient tenantActivityLogs;
    private final MetricDefinitionsClient metricDefinitions;
    private final MetricsClient metrics;
    private final MetricBaselinesClient metricBaselines;
    private final BaselinesClient baselines;
    private final MetricAlertsClient metricAlerts;
    private final MetricAlertsStatusClient metricAlertsStatus;
    private final ScheduledQueryRulesClient scheduledQueryRules;
    private final MetricNamespacesClient metricNamespaces;
    private final VMInsightsClient vMInsights;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public AutoscaleSettingsClient getAutoscaleSettings() {
        return this.autoscaleSettings;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public AlertRuleIncidentsClient getAlertRuleIncidents() {
        return this.alertRuleIncidents;
    }

    @Override
    public AlertRulesClient getAlertRules() {
        return this.alertRules;
    }

    @Override
    public LogProfilesClient getLogProfiles() {
        return this.logProfiles;
    }

    @Override
    public DiagnosticSettingsClient getDiagnosticSettings() {
        return this.diagnosticSettings;
    }

    @Override
    public DiagnosticSettingsCategoriesClient getDiagnosticSettingsCategories() {
        return this.diagnosticSettingsCategories;
    }

    @Override
    public ActionGroupsClient getActionGroups() {
        return this.actionGroups;
    }

    @Override
    public ActivityLogAlertsClient getActivityLogAlerts() {
        return this.activityLogAlerts;
    }

    @Override
    public ActivityLogsClient getActivityLogs() {
        return this.activityLogs;
    }

    @Override
    public EventCategoriesClient getEventCategories() {
        return this.eventCategories;
    }

    @Override
    public TenantActivityLogsClient getTenantActivityLogs() {
        return this.tenantActivityLogs;
    }

    @Override
    public MetricDefinitionsClient getMetricDefinitions() {
        return this.metricDefinitions;
    }

    @Override
    public MetricsClient getMetrics() {
        return this.metrics;
    }

    @Override
    public MetricBaselinesClient getMetricBaselines() {
        return this.metricBaselines;
    }

    @Override
    public BaselinesClient getBaselines() {
        return this.baselines;
    }

    @Override
    public MetricAlertsClient getMetricAlerts() {
        return this.metricAlerts;
    }

    @Override
    public MetricAlertsStatusClient getMetricAlertsStatus() {
        return this.metricAlertsStatus;
    }

    @Override
    public ScheduledQueryRulesClient getScheduledQueryRules() {
        return this.scheduledQueryRules;
    }

    @Override
    public MetricNamespacesClient getMetricNamespaces() {
        return this.metricNamespaces;
    }

    @Override
    public VMInsightsClient getVMInsights() {
        return this.vMInsights;
    }

    MonitorClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.autoscaleSettings = new AutoscaleSettingsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.alertRuleIncidents = new AlertRuleIncidentsClientImpl(this);
        this.alertRules = new AlertRulesClientImpl(this);
        this.logProfiles = new LogProfilesClientImpl(this);
        this.diagnosticSettings = new DiagnosticSettingsClientImpl(this);
        this.diagnosticSettingsCategories = new DiagnosticSettingsCategoriesClientImpl(this);
        this.actionGroups = new ActionGroupsClientImpl(this);
        this.activityLogAlerts = new ActivityLogAlertsClientImpl(this);
        this.activityLogs = new ActivityLogsClientImpl(this);
        this.eventCategories = new EventCategoriesClientImpl(this);
        this.tenantActivityLogs = new TenantActivityLogsClientImpl(this);
        this.metricDefinitions = new MetricDefinitionsClientImpl(this);
        this.metrics = new MetricsClientImpl(this);
        this.metricBaselines = new MetricBaselinesClientImpl(this);
        this.baselines = new BaselinesClientImpl(this);
        this.metricAlerts = new MetricAlertsClientImpl(this);
        this.metricAlertsStatus = new MetricAlertsStatusClientImpl(this);
        this.scheduledQueryRules = new ScheduledQueryRulesClientImpl(this);
        this.metricNamespaces = new MetricNamespacesClientImpl(this);
        this.vMInsights = new VMInsightsClientImpl(this);
    }
}

