// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Federated identity credential properties.
 *
 * <p>The properties associated with a federated identity credential.
 */
@Fluent
public final class FederatedIdentityCredentialProperties {
    /*
     * The URL of the issuer to be trusted.
     */
    @JsonProperty(value = "issuer", required = true)
    private String issuer;

    /*
     * The identifier of the external identity.
     */
    @JsonProperty(value = "subject", required = true)
    private String subject;

    /*
     * The list of audiences that can appear in the issued token.
     */
    @JsonProperty(value = "audiences", required = true)
    private List<String> audiences;

    /** Creates an instance of FederatedIdentityCredentialProperties class. */
    public FederatedIdentityCredentialProperties() {
    }

    /**
     * Get the issuer property: The URL of the issuer to be trusted.
     *
     * @return the issuer value.
     */
    public String issuer() {
        return this.issuer;
    }

    /**
     * Set the issuer property: The URL of the issuer to be trusted.
     *
     * @param issuer the issuer value to set.
     * @return the FederatedIdentityCredentialProperties object itself.
     */
    public FederatedIdentityCredentialProperties withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    /**
     * Get the subject property: The identifier of the external identity.
     *
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set the subject property: The identifier of the external identity.
     *
     * @param subject the subject value to set.
     * @return the FederatedIdentityCredentialProperties object itself.
     */
    public FederatedIdentityCredentialProperties withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the audiences property: The list of audiences that can appear in the issued token.
     *
     * @return the audiences value.
     */
    public List<String> audiences() {
        return this.audiences;
    }

    /**
     * Set the audiences property: The list of audiences that can appear in the issued token.
     *
     * @param audiences the audiences value to set.
     * @return the FederatedIdentityCredentialProperties object itself.
     */
    public FederatedIdentityCredentialProperties withAudiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (issuer() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property issuer in model FederatedIdentityCredentialProperties"));
        }
        if (subject() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property subject in model FederatedIdentityCredentialProperties"));
        }
        if (audiences() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property audiences in model FederatedIdentityCredentialProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FederatedIdentityCredentialProperties.class);
}
