// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

/**
 * System Assigned Identity properties.
 *
 * <p>The properties associated with the system assigned identity.
 */
@Immutable
public final class SystemAssignedIdentityProperties {
    /*
     * The id of the tenant which the identity belongs to.
     */
    @JsonProperty(value = "tenantId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID tenantId;

    /*
     * The id of the service principal object associated with the created identity.
     */
    @JsonProperty(value = "principalId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID principalId;

    /*
     * The id of the app associated with the identity. This is a random generated UUID by MSI.
     */
    @JsonProperty(value = "clientId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID clientId;

    /*
     * The ManagedServiceIdentity DataPlane URL that can be queried to obtain the identity credentials.
     */
    @JsonProperty(value = "clientSecretUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String clientSecretUrl;

    /** Creates an instance of SystemAssignedIdentityProperties class. */
    public SystemAssignedIdentityProperties() {
    }

    /**
     * Get the tenantId property: The id of the tenant which the identity belongs to.
     *
     * @return the tenantId value.
     */
    public UUID tenantId() {
        return this.tenantId;
    }

    /**
     * Get the principalId property: The id of the service principal object associated with the created identity.
     *
     * @return the principalId value.
     */
    public UUID principalId() {
        return this.principalId;
    }

    /**
     * Get the clientId property: The id of the app associated with the identity. This is a random generated UUID by
     * MSI.
     *
     * @return the clientId value.
     */
    public UUID clientId() {
        return this.clientId;
    }

    /**
     * Get the clientSecretUrl property: The ManagedServiceIdentity DataPlane URL that can be queried to obtain the
     * identity credentials.
     *
     * @return the clientSecretUrl value.
     */
    public String clientSecretUrl() {
        return this.clientSecretUrl;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
