// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.UUID;

/**
 * User Assigned Identity properties.
 * 
 * The properties associated with the user assigned identity.
 */
@Immutable
public final class UserAssignedIdentityProperties implements JsonSerializable<UserAssignedIdentityProperties> {
    /*
     * The id of the tenant which the identity belongs to.
     */
    private UUID tenantId;

    /*
     * The id of the service principal object associated with the created identity.
     */
    private UUID principalId;

    /*
     * The id of the app associated with the identity. This is a random generated UUID by MSI.
     */
    private UUID clientId;

    /**
     * Creates an instance of UserAssignedIdentityProperties class.
     */
    public UserAssignedIdentityProperties() {
    }

    /**
     * Get the tenantId property: The id of the tenant which the identity belongs to.
     * 
     * @return the tenantId value.
     */
    public UUID tenantId() {
        return this.tenantId;
    }

    /**
     * Get the principalId property: The id of the service principal object associated with the created identity.
     * 
     * @return the principalId value.
     */
    public UUID principalId() {
        return this.principalId;
    }

    /**
     * Get the clientId property: The id of the app associated with the identity. This is a random generated UUID by
     * MSI.
     * 
     * @return the clientId value.
     */
    public UUID clientId() {
        return this.clientId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserAssignedIdentityProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserAssignedIdentityProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserAssignedIdentityProperties.
     */
    public static UserAssignedIdentityProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserAssignedIdentityProperties deserializedUserAssignedIdentityProperties
                = new UserAssignedIdentityProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tenantId".equals(fieldName)) {
                    deserializedUserAssignedIdentityProperties.tenantId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("principalId".equals(fieldName)) {
                    deserializedUserAssignedIdentityProperties.principalId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("clientId".equals(fieldName)) {
                    deserializedUserAssignedIdentityProperties.clientId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserAssignedIdentityProperties;
        });
    }
}
