// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.msi.fluent.models.FederatedIdentityCredentialInner;
import java.io.IOException;
import java.util.List;

/**
 * Values returned by the List operation for federated identity credentials.
 */
@Fluent
public final class FederatedIdentityCredentialsListResult
    implements JsonSerializable<FederatedIdentityCredentialsListResult> {
    /*
     * The collection of federated identity credentials returned by the listing operation.
     */
    private List<FederatedIdentityCredentialInner> value;

    /*
     * The url to get the next page of results, if any.
     */
    private String nextLink;

    /**
     * Creates an instance of FederatedIdentityCredentialsListResult class.
     */
    public FederatedIdentityCredentialsListResult() {
    }

    /**
     * Get the value property: The collection of federated identity credentials returned by the listing operation.
     * 
     * @return the value value.
     */
    public List<FederatedIdentityCredentialInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The collection of federated identity credentials returned by the listing operation.
     * 
     * @param value the value value to set.
     * @return the FederatedIdentityCredentialsListResult object itself.
     */
    public FederatedIdentityCredentialsListResult withValue(List<FederatedIdentityCredentialInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The url to get the next page of results, if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The url to get the next page of results, if any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the FederatedIdentityCredentialsListResult object itself.
     */
    public FederatedIdentityCredentialsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FederatedIdentityCredentialsListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FederatedIdentityCredentialsListResult if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FederatedIdentityCredentialsListResult.
     */
    public static FederatedIdentityCredentialsListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FederatedIdentityCredentialsListResult deserializedFederatedIdentityCredentialsListResult
                = new FederatedIdentityCredentialsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<FederatedIdentityCredentialInner> value
                        = reader.readArray(reader1 -> FederatedIdentityCredentialInner.fromJson(reader1));
                    deserializedFederatedIdentityCredentialsListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialsListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFederatedIdentityCredentialsListResult;
        });
    }
}
